/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.xantheon.WorldGenRadiolariaSpouts;

public class BiomeDecoratorXantheon
extends BiomeDecoratorZG {
    private static final Block STONE = ZGBlocks.xantheonStone;
    private WorldGenerator chromeGen = new WorldGenMinableZG(ZGBlocks.xantheonChrome, ZGBlocks.xantheonRock, EnumOreGenZG.DIRT.setBlockCount(45));
    private WorldGenerator ironGen = new WorldGenMinableZG(ZGBlocks.xantheonIronOre, STONE, EnumOreGenZG.IRON);
    private WorldGenerator copperGen = new WorldGenMinableZG(ZGBlocks.xantheonCopperOre, STONE, EnumOreGenZG.COPPER);
    private WorldGenerator coalGen = new WorldGenMinableZG(ZGBlocks.xantheonCoalOre, STONE, EnumOreGenZG.COAL);
    private WorldGenerator nickelGen = new WorldGenMinableZG(ZGBlocks.xantheonNickelOre, STONE, EnumOreGenZG.NICKEL);
    private WorldGenerator plutoniumGen = new WorldGenMinableZG(ZGBlocks.xantheonPlutoniumOre, STONE, EnumOreGenZG.PLUTONIUM);
    private WorldGenerator fueltoniumGen = new WorldGenMinableZG(ZGBlocks.xantheonFueltoniumOre, STONE, EnumOreGenZG.FUELTONIUM);
    private WorldGenerator amaranthGen = new WorldGenMinableZG(ZGBlocks.xantheonAmaranthOre, STONE, EnumOreGenZG.AMARANTH);
    private WorldGenerator constructGen = new WorldGenMinableZG(ZGBlocks.xantheonConstructBlock, STONE, EnumOreGenZG.CONSTRUCTED);
    public boolean generateLakes = true;
    public boolean generateSpouts = true;
    public int whiteLavaLakesPerChunk = 1;

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        this.generateOre(this.chromeGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.copperGen, EnumOreGenZG.COPPER, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.coalGen, EnumOreGenZG.COAL, world, rand);
        this.generateOre(this.nickelGen, EnumOreGenZG.NICKEL, world, rand);
        this.generateOre(this.plutoniumGen, EnumOreGenZG.PLUTONIUM, world, rand);
        this.generateOre(this.fueltoniumGen, EnumOreGenZG.FUELTONIUM, world, rand);
        this.generateOre(this.amaranthGen, EnumOreGenZG.AMARANTH, world, rand);
        this.generateOre(this.constructGen, EnumOreGenZG.CONSTRUCTED, world, rand);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        int y = genY = 248;
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.whiteLavaLakesPerChunk > 0) {
            for (int i = 0; i < this.whiteLavaLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(150) > 10 || y > 62) continue;
                new WorldGenLakesZG((Block)ZGFluids.blockWhiteLavaFluid, STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateSpouts) {
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (rand.nextInt(100) <= 5 && y >= 70 && y <= 90) {
                new WorldGenRadiolariaSpouts().func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

