/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderMetztli;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGDecorateHelper;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.WorldGenBattleTower;
import zollerngalaxy.worldgen.WorldGenCrops;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenZGMushroomTree;

public class BiomeDecoratorMetztli
extends BiomeDecoratorZG {
    private static final Block STONE = Blocks.field_150348_b;
    private static final Block GRASS = Blocks.field_150349_c;
    private WorldGenerator dirtGen;
    private WorldGenerator graniteGen;
    private WorldGenerator dioriteGen;
    private WorldGenerator andesiteGen;
    private WorldGenerator ironGen;
    private WorldGenerator goldGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator diamondGen;
    private WorldGenerator emeraldGen;
    private WorldGenerator lapisGen;
    private WorldGenerator aquamarineGen;
    private WorldGenerator amberGen;
    private WorldGenerator zincGen;
    private WorldGenerator garnetGen;
    private WorldGenerator superChargedCoalGen;
    private WorldGenerator sapphireGen;
    private WorldGenerator opalGen;
    private WorldGenerator rubyGen;
    private WorldGenerator amaranthGen;
    private WorldGenerator topazGen;
    private WorldGenerator fueltoniumGen;
    private WorldGenerator tallGrassGen = new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    private WorldGenerator fernGen = new WorldGenTallGrass(BlockTallGrass.EnumType.FERN);
    private WorldGenerator treeGenMushroom = new WorldGenZGMushroomTree(false, ZGHelper.rngInt(3, 10));
    private WorldGenerator waterLilyGen = new WorldGenWaterlily();
    private WorldGenerator treeGen = new WorldGenBigTree(true);
    private WorldGenerator cactusGen = new WorldGenCactus();
    private WorldGenerator deadBushGen = new WorldGenDeadBush();
    private WorldGenerator battleTowerGen = new WorldGenBattleTower(Blocks.field_150347_e.func_176223_P(), Blocks.field_150426_aN.func_176223_P());
    private WorldGenerator cropGen;
    private WorldGenerator jungleTreeGen;
    public int waterLakesPerChunk = 2;
    public int lavaLakesPerChunk = 2;
    public int oilPerChunk = 3;
    public int waterLilyPerChunk = 4;
    public int tallGrassPerChunk = 6;
    public int field_76832_z = 4;
    public int mushroomTreesPerChunk = 2;
    public int field_76800_F = 5;
    public int deadBushesPerChunk = 4;
    public int field_76799_E = 4;
    public int battleTowersPerChunk = 2;
    public int cropsPerChunk = 2;
    public int fernsPerChunk = 4;
    public int jungleTreesPerChunk = 0;
    public int field_76798_D = 20;
    public int field_76806_I = 3;
    public int field_76801_G = 2;
    public int field_76805_H = 3;
    public boolean generateLakes = true;
    public boolean generateWaterLilies = true;
    public boolean generateTallGrass = true;
    public boolean generateTrees = true;
    public boolean generateMushroomTrees = false;
    public boolean generateCraters = true;
    public boolean generateCacti = false;
    public boolean generateDeadBushes = false;
    public boolean generateReeds = true;
    public boolean generateVines = false;
    public boolean generateBattleTowers = true;
    public boolean generateCrops = true;
    public boolean generateFerns = true;
    public boolean generateJungleTrees = false;
    public boolean generateMushrooms = true;
    public boolean generateOil = true;

    public BiomeDecoratorMetztli() {
        this.dirtGen = new WorldGenMinableZG(Blocks.field_150346_d, GRASS, EnumOreGenZG.DIRT);
        this.graniteGen = new WorldGenMinableZG(STONE.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), STONE.func_176223_P(), EnumOreGenZG.STONE);
        this.dioriteGen = new WorldGenMinableZG(STONE.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), STONE.func_176223_P(), EnumOreGenZG.STONE);
        this.andesiteGen = new WorldGenMinableZG(STONE.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), STONE.func_176223_P(), EnumOreGenZG.STONE);
        this.ironGen = new WorldGenMinableZG(Blocks.field_150366_p, STONE, EnumOreGenZG.IRON);
        this.goldGen = new WorldGenMinableZG(Blocks.field_150352_o, STONE, EnumOreGenZG.GOLD);
        this.redstoneGen = new WorldGenMinableZG(Blocks.field_150450_ax, STONE, EnumOreGenZG.REDSTONE);
        this.diamondGen = new WorldGenMinableZG(Blocks.field_150482_ag, STONE, EnumOreGenZG.DIAMOND);
        this.emeraldGen = new WorldGenMinableZG(Blocks.field_150412_bA, STONE, EnumOreGenZG.EMERALD);
        this.lapisGen = new WorldGenMinableZG(Blocks.field_150369_x, STONE, EnumOreGenZG.LAPIS);
        this.aquamarineGen = new WorldGenMinableZG(ZGBlocks.harranAquamarineOre, STONE, EnumOreGenZG.POWER_GEM);
        this.amberGen = new WorldGenMinableZG(ZGBlocks.harranAmberOre, STONE, EnumOreGenZG.POWER_GEM);
        this.zincGen = new WorldGenMinableZG(ZGBlocks.harranZincOre, STONE, EnumOreGenZG.ZINC);
        this.garnetGen = new WorldGenMinableZG(ZGBlocks.harranGarnetOre, STONE, EnumOreGenZG.POWER_GEM);
        this.superChargedCoalGen = new WorldGenMinableZG(ZGBlocks.harranSuperChargedCoalOre, STONE, EnumOreGenZG.SUPER_CHARGED_COAL);
        this.sapphireGen = new WorldGenMinableZG(ZGBlocks.harranSapphireOre, STONE, EnumOreGenZG.SAPPHIRE);
        this.opalGen = new WorldGenMinableZG(ZGBlocks.harranOpalOre, STONE, EnumOreGenZG.POWER_GEM);
        this.rubyGen = new WorldGenMinableZG(ZGBlocks.harranRubyOre, STONE, EnumOreGenZG.RUBY);
        this.amaranthGen = new WorldGenMinableZG(ZGBlocks.harranAmaranthOre, STONE, EnumOreGenZG.AMARANTH);
        this.topazGen = new WorldGenMinableZG(ZGBlocks.harranTopazOre, STONE, EnumOreGenZG.POWER_GEM);
        this.fueltoniumGen = new WorldGenMinableZG(ZGBlocks.harranFueltoniumOre, STONE, EnumOreGenZG.FUELTONIUM);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int y2;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int y = rand.nextInt(120) + 8;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        Block BLOCK_STONE = Blocks.field_150348_b;
        this.generateOre(this.dirtGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.graniteGen, EnumOreGenZG.STONE, world, rand);
        this.generateOre(this.dioriteGen, EnumOreGenZG.STONE, world, rand);
        this.generateOre(this.andesiteGen, EnumOreGenZG.STONE, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.emeraldGen, EnumOreGenZG.EMERALD, world, rand);
        this.generateOre(this.lapisGen, EnumOreGenZG.LAPIS, world, rand);
        this.generateOre(this.aquamarineGen, EnumOreGenZG.POWER_GEM, world, rand);
        this.generateOre(this.amberGen, EnumOreGenZG.POWER_GEM, world, rand);
        this.generateOre(this.zincGen, EnumOreGenZG.ZINC, world, rand);
        this.generateOre(this.garnetGen, EnumOreGenZG.POWER_GEM, world, rand);
        this.generateOre(this.superChargedCoalGen, EnumOreGenZG.SUPER_CHARGED_COAL, world, rand);
        this.generateOre(this.opalGen, EnumOreGenZG.POWER_GEM, world, rand);
        this.generateOre(this.rubyGen, EnumOreGenZG.RUBY, world, rand);
        this.generateOre(this.amaranthGen, EnumOreGenZG.AMARANTH, world, rand);
        this.generateOre(this.topazGen, EnumOreGenZG.POWER_GEM, world, rand);
        this.generateOre(this.fueltoniumGen, EnumOreGenZG.FUELTONIUM, world, rand);
        int genY = y;
        if (biome instanceof BiomeSpace) {
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.lavaLakesPerChunk > 0) {
            for (int i = 0; i < this.lavaLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(this.enableExtremeMode ? 75 : 100) > 50) continue;
                new WorldGenLakesZG((Block)Blocks.field_150353_l, BLOCK_STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && this.generateLakes && this.waterLakesPerChunk > 0) {
            int i;
            for (i = 0; i < this.waterLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                Block blockToUse = BiomeUtils.isColdBiome(biome) ? Blocks.field_150432_aD : Blocks.field_150355_j;
                new WorldGenLakesZG(blockToUse, BLOCK_TOP).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
            if (this.generateWaterLilies && this.field_76833_y > 0) {
                for (i = 0; i < this.field_76833_y; ++i) {
                    this.waterLilyGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateOil && this.oilPerChunk > 0 && ConfigManagerZG.enableOilLakes) {
            for (int i = 0; i < this.oilPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                new WorldGenLakesZG(GCBlocks.crudeOil, BLOCK_STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                EventHandlerGC.generateOil((World)world, (Random)rand, (int)x, (int)z, (boolean)false);
            }
        }
        if (this.generateTallGrass && this.tallGrassPerChunk > 0) {
            for (int i = 0; i < this.tallGrassPerChunk + 4; ++i) {
                ZGDecorateHelper.generatePlants(this.tallGrassGen, world, rand, this.field_180294_c);
            }
        }
        if (this.generateFerns && this.fernsPerChunk > 0) {
            for (int i = 0; i < this.fernsPerChunk + 2; ++i) {
                ZGDecorateHelper.generatePlants(this.fernGen, world, rand, this.field_180294_c);
            }
        }
        if (this.generateBattleTowers && this.battleTowersPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 250) <= 35) {
            for (int i = 0; i < this.battleTowersPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 60 || y >= 80) continue;
                this.battleTowerGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateCrops && this.cropsPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 100) <= 45) {
            for (int i = 0; i < this.cropsPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 62) continue;
                this.cropGen = new WorldGenCrops(ZGHelper.getRandomCrop(rand).func_176223_P());
                this.cropGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        int k1 = this.field_76832_z;
        if (rand.nextFloat() < this.field_189870_A) {
            ++k1;
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && this.generateTrees && this.field_76832_z > 0) {
            for (int i = 0; i < k1; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 64) {
                    y = ZGHelper.rngInt(64, 82);
                }
                if (rand.nextInt(100) > 45) continue;
                this.treeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && this.generateJungleTrees && this.jungleTreesPerChunk > 0) {
            for (int i = 0; i <= this.jungleTreesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 64) {
                    y = ZGHelper.rngInt(64, 82);
                }
                IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
                IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
                IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
                if (rand.nextInt(100) > 85) continue;
                this.jungleTreeGen = rand.nextInt(2) == 0 ? new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF) : new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
                this.jungleTreeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM) && this.generateMushroomTrees && this.mushroomTreesPerChunk > 0) {
            for (int i = 0; i < this.mushroomTreesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 64) {
                    y = ZGHelper.rngInt(64, 82);
                }
                if (rand.nextInt(100) > 45) continue;
                this.treeGenMushroom.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateCraters) {
            ChunkProviderMetztli.INSTANCE.createCraters(x, z, chunkPrimer);
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS) && rand.nextInt(2) == 0) {
            for (int i = 0; i < this.field_76800_F; ++i) {
                int z1;
                int x1 = rand.nextInt(16) + 8;
                int y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.cactusGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH) && rand.nextInt(2) == 0) {
            for (int i = 0; i < this.field_76804_C; ++i) {
                int z1;
                int x1 = rand.nextInt(16) + 8;
                int y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.deadBushGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int l2 = 0; l2 < this.field_76802_A; ++l2) {
                int k17;
                BlockPos blockpos1;
                BlockFlower.EnumFlowerType blockflower$enumflowertype;
                BlockFlower blockflower;
                int l10;
                int i7 = rand.nextInt(16) + 8;
                int j14 = world.func_175645_m(this.field_180294_c.func_177982_a(i7, 0, l10 = rand.nextInt(16) + 8)).func_177956_o() + 32;
                if (j14 <= 0 || (blockflower = (blockflower$enumflowertype = biome.func_180623_a(rand, blockpos1 = this.field_180294_c.func_177982_a(i7, k17 = rand.nextInt(j14), l10))).func_176964_a().func_180346_a()).func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                this.field_150514_p.func_175914_a(blockflower, blockflower$enumflowertype);
                this.field_150514_p.func_180709_b(world, rand, blockpos1);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED) && rand.nextInt(4) == 0) {
            for (int i = 0; i < this.field_76799_E; ++i) {
                int z1;
                int x1 = rand.nextInt(16) + 8;
                int y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.field_76825_v.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY)) {
            for (int i1 = 0; i1 < this.field_76806_I; ++i1) {
                int l1 = rand.nextInt(16) + 8;
                int i6 = rand.nextInt(16) + 8;
                this.field_76809_f.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(l1, 0, i6)));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2)) {
            for (int j1 = 0; j1 < this.field_76801_G; ++j1) {
                int i2 = rand.nextInt(16) + 8;
                int j6 = rand.nextInt(16) + 8;
                this.field_76822_h.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(i2, 0, j6)));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && rand.nextInt(4) == 0) {
            for (int j2 = 0; j2 < y; ++j2) {
                int k6 = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                WorldGenAbstractTree worldgenabstracttree = biome.func_150567_a(rand);
                worldgenabstracttree.func_175904_e();
                BlockPos blockpos = world.func_175645_m(this.field_180294_c.func_177982_a(k6, 0, l));
                if (!worldgenabstracttree.func_180709_b(world, rand, blockpos)) continue;
                worldgenabstracttree.func_180711_a(world, rand, blockpos);
            }
        }
        if (this.field_76808_K) {
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                for (int k5 = 0; k5 < 50; ++k5) {
                    int i10 = rand.nextInt(16) + 8;
                    int l13 = rand.nextInt(16) + 8;
                    int i17 = rand.nextInt(120) + 8;
                    if (i17 <= 0) continue;
                    int k19 = rand.nextInt(i17);
                    BlockPos blockpos6 = this.field_180294_c.func_177982_a(i10, k19, l13);
                    new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(world, rand, blockpos6);
                }
            }
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                for (int l5 = 0; l5 < 20; ++l5) {
                    int j10 = rand.nextInt(16) + 8;
                    int i14 = rand.nextInt(16) + 8;
                    int j17 = rand.nextInt(rand.nextInt(rand.nextInt(112) + 8) + 8);
                    BlockPos blockpos3 = this.field_180294_c.func_177982_a(j10, j17, i14);
                    new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(world, rand, blockpos3);
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM) && this.generateMushrooms) {
            int l8;
            int j4;
            int k12;
            int k8;
            int i4;
            int j12;
            for (int l3 = 0; l3 < this.field_76798_D; ++l3) {
                int i12;
                int j8;
                int j15;
                if (rand.nextInt(4) == 0) {
                    int i8 = rand.nextInt(16) + 8;
                    int l11 = rand.nextInt(16) + 8;
                    BlockPos blockpos2 = world.func_175645_m(this.field_180294_c.func_177982_a(i8, 0, l11));
                    this.field_76828_s.func_180709_b(world, rand, blockpos2);
                }
                if (rand.nextInt(8) != 0 || (j15 = world.func_175645_m(this.field_180294_c.func_177982_a(j8 = rand.nextInt(16) + 8, 0, i12 = rand.nextInt(16) + 8)).func_177956_o() * 2) <= 0) continue;
                int k18 = rand.nextInt(j15);
                BlockPos blockpos5 = this.field_180294_c.func_177982_a(j8, k18, i12);
                this.field_76827_t.func_180709_b(world, rand, blockpos5);
            }
            if (rand.nextInt(4) == 0 && (j12 = world.func_175645_m(this.field_180294_c.func_177982_a(i4 = rand.nextInt(16) + 8, 0, k8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int k15 = rand.nextInt(j12);
                this.field_76828_s.func_180709_b(world, rand, this.field_180294_c.func_177982_a(i4, k15, k8));
            }
            if (rand.nextInt(8) == 0 && (k12 = world.func_175645_m(this.field_180294_c.func_177982_a(j4 = rand.nextInt(16) + 8, 0, l8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int l15 = rand.nextInt(k12);
                this.field_76827_t.func_180709_b(world, rand, this.field_180294_c.func_177982_a(j4, l15, l8));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND)) {
            for (int i = 0; i < this.field_76805_H; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                this.field_76810_g.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(j, 0, k)));
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

