/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderMaveth;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.WorldGenBattleTower;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenSmallCraterZG;
import zollerngalaxy.worldgen.WorldGenTunnel;

public class BiomeDecoratorMaveth
extends BiomeDecoratorZG {
    private static final Block STONE = ZGBlocks.mavethStone;
    private static final Block ROCK = ZGBlocks.mavethRock;
    private WorldGenerator ironGen;
    private WorldGenerator electrumGen;
    private WorldGenerator amaranthGen;
    private WorldGenerator zollerniumGen;
    private WorldGenerator vibraniumGen;
    private WorldGenerator tunnelGen = new WorldGenTunnel();
    private WorldGenerator craterGen = new WorldGenSmallCraterZG();
    private WorldGenerator battleTowerGen = new WorldGenBattleTower(ZGBlocks.mavethCobblestone.func_176223_P(), ZGBlocks.mavethRock.func_176223_P());
    public int tunnelsPerChunk = 5;
    public int cratersPerChunk = 2;
    public int battleTowersPerChunk = 1;
    public int waterLakesPerChunk = 1;
    public int lavaLakesPerChunk = 1;
    public int field_76798_D = 2;
    public boolean generateCraters = true;
    public boolean generateTunnels = true;
    public boolean generateBattleTowers = true;
    public boolean generateLakes = true;
    public boolean generateMushrooms = true;

    public BiomeDecoratorMaveth() {
        this.ironGen = new WorldGenMinableZG(ZGBlocks.mavethIronOre, STONE, EnumOreGenZG.IRON);
        this.electrumGen = new WorldGenMinableZG(ZGBlocks.mavethElectrumOre, STONE, EnumOreGenZG.ELECTRUM);
        this.amaranthGen = new WorldGenMinableZG(ZGBlocks.mavethAmaranthOre, STONE, EnumOreGenZG.AMARANTH);
        this.zollerniumGen = new WorldGenMinableZG(ZGBlocks.mavethZollerniumOre, STONE, EnumOreGenZG.ZOLLERNIUM);
        this.vibraniumGen = new WorldGenMinableZG(ZGBlocks.mavethVibraniumOre, STONE, EnumOreGenZG.VIBRANIUM);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        int y = genY = 248;
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        Block BLOCK_STONE = ZGBlocks.mavethStone;
        if (biome instanceof BiomeSpace) {
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.electrumGen, EnumOreGenZG.SHINIUM, world, rand);
        this.generateOre(this.amaranthGen, EnumOreGenZG.FUELTONIUM, world, rand);
        this.generateOre(this.zollerniumGen, EnumOreGenZG.ZOLLERNIUM, world, rand);
        this.generateOre(this.vibraniumGen, EnumOreGenZG.VIBRANIUM, world, rand);
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.lavaLakesPerChunk > 0) {
            for (int i = 0; i < this.lavaLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(this.enableExtremeMode ? 75 : 100) > 50) continue;
                new WorldGenLakesZG((Block)Blocks.field_150353_l, BLOCK_STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && this.generateLakes && this.waterLakesPerChunk > 0) {
            for (int i = 0; i < this.waterLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                Block blockToUse = BiomeUtils.isColdBiome(biome) ? Blocks.field_150432_aD : Blocks.field_150355_j;
                new WorldGenLakesZG(blockToUse, BLOCK_TOP).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateOil && this.oilPerChunk > 0 && this.enableOilGen) {
            for (int i = 0; i < this.oilPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                new WorldGenLakesZG(GCBlocks.crudeOil, ZGBlocks.edenStone).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                EventHandlerGC.generateOil((World)world, (Random)rand, (int)x, (int)z, (boolean)false);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM) && this.generateMushrooms && this.field_76798_D > 0) {
            int l8;
            int j4;
            int k12;
            int k8;
            int i4;
            int j12;
            for (int l3 = 0; l3 < this.field_76798_D; ++l3) {
                int i12;
                int j8;
                int j15;
                if (rand.nextInt(4) == 0) {
                    int i8 = rand.nextInt(16) + 8;
                    int l11 = rand.nextInt(16) + 8;
                    BlockPos blockpos2 = world.func_175645_m(this.field_180294_c.func_177982_a(i8, 0, l11));
                    this.field_76828_s.func_180709_b(world, rand, blockpos2);
                }
                if (rand.nextInt(8) != 0 || (j15 = world.func_175645_m(this.field_180294_c.func_177982_a(j8 = rand.nextInt(16) + 8, 0, i12 = rand.nextInt(16) + 8)).func_177956_o() * 2) <= 0) continue;
                int k18 = rand.nextInt(j15);
                BlockPos blockpos5 = this.field_180294_c.func_177982_a(j8, k18, i12);
                this.field_76827_t.func_180709_b(world, rand, blockpos5);
            }
            if (rand.nextInt(4) == 0 && (j12 = world.func_175645_m(this.field_180294_c.func_177982_a(i4 = rand.nextInt(16) + 8, 0, k8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int k15 = rand.nextInt(j12);
                this.field_76828_s.func_180709_b(world, rand, this.field_180294_c.func_177982_a(i4, k15, k8));
            }
            if (rand.nextInt(8) == 0 && (k12 = world.func_175645_m(this.field_180294_c.func_177982_a(j4 = rand.nextInt(16) + 8, 0, l8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int l15 = rand.nextInt(k12);
                this.field_76827_t.func_180709_b(world, rand, this.field_180294_c.func_177982_a(j4, l15, l8));
            }
        }
        if (this.field_76808_K) {
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                for (int k5 = 0; k5 < 50; ++k5) {
                    int i10 = rand.nextInt(16) + 8;
                    int l13 = rand.nextInt(16) + 8;
                    int i17 = rand.nextInt(120) + 8;
                    if (i17 <= 0) continue;
                    int k19 = rand.nextInt(i17);
                    BlockPos blockpos6 = this.field_180294_c.func_177982_a(i10, k19, l13);
                    new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(world, rand, blockpos6);
                }
            }
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                for (int l5 = 0; l5 < 20; ++l5) {
                    int j10 = rand.nextInt(16) + 8;
                    int i14 = rand.nextInt(16) + 8;
                    int j17 = rand.nextInt(rand.nextInt(rand.nextInt(112) + 8) + 8);
                    BlockPos blockpos3 = this.field_180294_c.func_177982_a(j10, j17, i14);
                    new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(world, rand, blockpos3);
                }
            }
        }
        if (this.generateTunnels && this.tunnelsPerChunk > 0 && ZGHelper.rngInt(1, 100) <= 35) {
            y = rand.nextInt(rand.nextInt(genY) + 8);
            for (int i = 0; i < this.tunnelsPerChunk; ++i) {
                if (y > 60) continue;
                this.tunnelGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        int craterSpawnChance = ConfigManagerZG.craterSpawnChance;
        if (this.generateCraters && this.cratersPerChunk > 0 && craterSpawnChance > 0) {
            ChunkProviderMaveth.INSTANCE.createCraters(x, z, chunkPrimer);
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (ZGHelper.rngInt(1, 100) <= craterSpawnChance) {
                for (int i = 0; i < this.cratersPerChunk; ++i) {
                    if (y > 70) continue;
                    this.craterGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
        if (this.generateBattleTowers && this.battleTowersPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 250) <= 25) {
            for (int i = 0; i < this.battleTowersPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 60 || y >= 80) continue;
                this.battleTowerGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

