/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenSand;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlockTallGrass;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderExodus;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGDecorateHelper;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.WorldGenBattleTower;
import zollerngalaxy.worldgen.WorldGenCrops;
import zollerngalaxy.worldgen.WorldGenFlowersZG;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenTallGrassZG;

public class BiomeDecoratorExodus
extends BiomeDecoratorZG {
    private WorldGenerator dirtGen;
    private WorldGenerator gravGen;
    private WorldGenerator ironOreGen;
    private WorldGenerator goldOreGen;
    private WorldGenerator diamondOreGen;
    private WorldGenerator redstoneOreGen;
    private WorldGenerator copperOreGen;
    private WorldGenerator tallGrassGen = new WorldGenTallGrassZG((ZGBlockTallGrass)ZGBlocks.exodusTallGrass);
    private WorldGenerator flowerGen = new WorldGenFlowersZG(ZGBlocks.exodusFlower.func_176223_P());
    private WorldGenerator sandGen = new WorldGenSand(ZGBlocks.exodusSand, 7);
    private WorldGenerator gravelGen = new WorldGenSand(ZGBlocks.exodusGravel, 6);
    private WorldGenerator battleTowerGen = new WorldGenBattleTower(ZGBlocks.exoWoodPlanks.func_176223_P(), ZGBlocks.blockShinestonePolished.func_176223_P());
    private WorldGenerator cropGen;
    public boolean generateLakes = true;
    public boolean generateVines = false;
    public boolean generateTrees = true;
    public boolean generateCraters = true;
    public boolean generateCrops = true;
    public boolean generateBattleTowers = true;
    public int tallGrassPerChunk = 10;
    public int waterLakesPerChunk = 2;
    public int lavaLakesPerChunk = this.enableExtremeMode ? 12 : 6;
    public int field_76802_A = 2;
    public int cropsPerChunk = 2;
    public int battleTowersPerChunk = 2;
    private static final Block STONE = ZGBlocks.exodusStone;

    public BiomeDecoratorExodus() {
        this.dirtGen = new WorldGenMinableZG(ZGBlocks.exodusDirt, ZGBlocks.exodusGrass, EnumOreGenZG.DIRT);
        this.gravGen = new WorldGenMinableZG(ZGBlocks.exodusGravel, STONE, EnumOreGenZG.GRAVEL);
        this.ironOreGen = new WorldGenMinableZG(ZGBlocks.exodusIronOre, STONE, EnumOreGenZG.IRON);
        this.goldOreGen = new WorldGenMinableZG(ZGBlocks.exodusGoldOre, STONE, EnumOreGenZG.GOLD);
        this.diamondOreGen = new WorldGenMinableZG(ZGBlocks.exodusDiamondOre, STONE, EnumOreGenZG.DIAMOND);
        this.redstoneOreGen = new WorldGenMinableZG(ZGBlocks.exodusRedstoneOre, STONE, EnumOreGenZG.REDSTONE);
        this.copperOreGen = new WorldGenMinableZG(ZGBlocks.exodusCopperOre, STONE, EnumOreGenZG.COPPER);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        BiomeSpace spaceBiome;
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        int y = genY = 248;
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        Block BLOCK_STONE = STONE;
        if (biome instanceof BiomeSpace) {
            spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        this.generateOre(this.dirtGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.gravGen, EnumOreGenZG.GRAVEL, world, rand);
        this.generateOre(this.ironOreGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.goldOreGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.diamondOreGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.redstoneOreGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.copperOreGen, EnumOreGenZG.COPPER, world, rand);
        if (this.tallGrassPerChunk > 0) {
            for (int i = 0; i < this.tallGrassPerChunk + 4; ++i) {
                ZGDecorateHelper.generatePlants(this.tallGrassGen, world, rand, this.field_180294_c);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && this.generateLakes && this.waterLakesPerChunk > 0) {
            for (int i = 0; i < this.waterLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                Block blockToUse = biome.func_150561_m() == Biome.TempCategory.COLD ? Blocks.field_150432_aD : Blocks.field_150355_j;
                new WorldGenLakesZG(blockToUse, BLOCK_TOP).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.lavaLakesPerChunk > 0) {
            for (int i = 0; i < this.lavaLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(this.enableExtremeMode ? 75 : 100) > 50) continue;
                new WorldGenLakesZG((Block)Blocks.field_150353_l, BLOCK_STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int l2 = 0; l2 < this.field_76802_A; ++l2) {
                int l10;
                int i7 = rand.nextInt(16) + 8;
                int j14 = world.func_175645_m(this.field_180294_c.func_177982_a(i7, 0, l10 = rand.nextInt(16) + 8)).func_177956_o() + 32;
                if (j14 <= 0) continue;
                int k17 = rand.nextInt(j14);
                BlockPos blockpos1 = this.field_180294_c.func_177982_a(i7, k17, l10);
                Block blockflower = ZGBlocks.exodusFlower;
                if (blockflower.func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                this.flowerGen.func_180709_b(world, rand, blockpos1);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && rand.nextInt(3) == 0) {
            for (int j2 = 0; j2 < y; ++j2) {
                int k6 = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                WorldGenAbstractTree worldgenabstracttree = biome.func_150567_a(rand);
                worldgenabstracttree.func_175904_e();
                BlockPos blockpos = world.func_175645_m(this.field_180294_c.func_177982_a(k6, 0, l));
                if (!worldgenabstracttree.func_180709_b(world, rand, blockpos)) continue;
                worldgenabstracttree.func_180711_a(world, rand, blockpos);
            }
        }
        if (this.field_76808_K) {
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                for (int k5 = 0; k5 < 50; ++k5) {
                    int i10 = rand.nextInt(16) + 8;
                    int l13 = rand.nextInt(16) + 8;
                    int i17 = rand.nextInt(120) + 8;
                    if (i17 <= 0) continue;
                    int k19 = rand.nextInt(i17);
                    BlockPos blockpos6 = this.field_180294_c.func_177982_a(i10, k19, l13);
                    new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(world, rand, blockpos6);
                }
            }
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                for (int l5 = 0; l5 < 20; ++l5) {
                    int j10 = rand.nextInt(16) + 8;
                    int i14 = rand.nextInt(16) + 8;
                    int j17 = rand.nextInt(rand.nextInt(rand.nextInt(112) + 8) + 8);
                    BlockPos blockpos3 = this.field_180294_c.func_177982_a(j10, j17, i14);
                    new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(world, rand, blockpos3);
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND)) {
            for (int i = 0; i < this.field_76805_H; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                this.sandGen.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(j, 0, k)));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2)) {
            for (int j1 = 0; j1 < this.field_76801_G; ++j1) {
                int i2 = rand.nextInt(16) + 8;
                int j6 = rand.nextInt(16) + 8;
                this.gravelGen.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(i2, 0, j6)));
            }
        }
        if (this.generateCrops && this.cropsPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 100) <= 45) {
            for (int i = 0; i < this.cropsPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 62) continue;
                this.cropGen = new WorldGenCrops(ZGHelper.getRandomCrop(rand).func_176223_P());
                this.cropGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateCraters) {
            ChunkProviderExodus.INSTANCE.createCraters(x, z, chunkPrimer);
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

