/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.centotl;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorCentotl;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.compat.AvPCompat;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.lib.helpers.ModHelperBase;
import zollerngalaxy.mobs.entities.EntityFacehugger;
import zollerngalaxy.mobs.entities.EntityXenomorph;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.villagers.EntityCentotlVillager;

public class BiomeCentoBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.centoStone.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = ZGBlocks.centoGravel.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.centoDirt.func_176223_P();
    protected static final IBlockState CONSTRUCT_BLOCK = ZGBlocks.xantheonConstructBlock.func_176223_P();
    protected static final int SEA_LEVEL = 46;
    protected static final int SEA_FLOOR_LEVEL = 25;
    public BiomeDecoratorCentotl biomeDecor = this.getBiomeDecorator();

    public BiomeCentoBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.WARM);
        this.setTemp(8.42f);
        this.clearAllSpawning();
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 10, 1, 2));
        }
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityFacehugger.class, 4, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityXenomorph.class, 2, 1, 1));
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityCentotlVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        if (ModHelperBase.useAvP && ConfigManagerZG.enableAvPCompat) {
            AvPCompat.addAvPSpawns((Biome)this);
        }
        this.setBodyForBiome(ZGPlanets.planetCentotl);
    }

    public final void generateCentotlTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 2.0 + 2.5 + rand.nextDouble() * 0.35);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 46 && j1 > 25) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, CONSTRUCT_BLOCK);
                    continue;
                }
                if (j1 < 25) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 25) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 46) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2 != STONE) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = CONSTRUCT_BLOCK;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateCentotlTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorCentotl();
    }

    protected BiomeDecoratorCentotl getBiomeDecorator() {
        return (BiomeDecoratorCentotl)this.field_76760_I;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

