/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.altum;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorAltum;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZGLootTables;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.EntityBladeFish;
import zollerngalaxy.mobs.entities.EntityBlubberFish;
import zollerngalaxy.mobs.entities.EntityGypsyFish;
import zollerngalaxy.mobs.entities.EntityJellyfish;
import zollerngalaxy.mobs.entities.EntityShark;
import zollerngalaxy.mobs.entities.EntitySquidlus;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.villagers.EntityAbyssalVillager;
import zollerngalaxy.worldgen.WorldGenTreasure;

public class BiomeAltumBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.altumStone.func_176223_P();
    protected static final IBlockState ROCK = ZGBlocks.altumRock.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = ZGBlocks.altumGravel.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.altumDirt.func_176223_P();
    protected static final IBlockState SAND = ZGBlocks.altumSand.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState SEAWEED = ZGBlocks.altumSeaweed.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final IBlockState SPONGE = Blocks.field_150360_v.func_176223_P();
    protected static final PropertyBool WET = PropertyBool.func_177716_a((String)"wet");
    protected static final ResourceLocation LOOT_TABLE = ZGLootTables.CHEST_OCEAN_TREASURE;
    protected static final WorldGenerator OCEAN_TREASURE_GEN = new WorldGenTreasure(LOOT_TABLE);
    protected static final int SEA_LEVEL = 74;
    protected static final int SEA_FLOOR_LEVEL = 42;
    public BiomeDecoratorAltum biomeDecor = this.getBiomeDecorator();

    public BiomeAltumBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        props.func_185398_c(0.5f);
        props.func_185400_d(0.6f);
        this.setTempCategory(Biome.TempCategory.MEDIUM);
        this.setBiomeHeight(45);
        this.setTemp(84.23f);
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 10, 1, 2));
        }
        this.addWaterSpawns();
        this.field_76759_H = 139;
        this.setPlanetForBiome(ZGPlanets.planetAltum);
    }

    public final void generateAltumTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int z2 = x & 0xF;
        int x2 = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            if (y == 0) {
                chunkPrimerIn.func_177855_a(x2, y, z2, BEDROCK);
                continue;
            }
            if (y >= 128) {
                chunkPrimerIn.func_177855_a(x2, y, z2, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(x2, y, z2);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                topState = SAND;
                fillState = ROCK;
                if (y < 74 && y > 42) {
                    chunkPrimerIn.func_177855_a(x2, y, z2, WATER);
                    continue;
                }
                if (y < 42) {
                    chunkPrimerIn.func_177855_a(x2, y, z2, STONE);
                    continue;
                }
                if (y == 42) {
                    if (rand.nextInt(10) == 2) {
                        chunkPrimerIn.func_177855_a(x2, y + 1, z2, SPONGE.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)));
                    }
                    if (rand.nextInt(10) == 2) {
                        chunkPrimerIn.func_177855_a(x2, y + 1, z2 + 1, GRAVEL);
                        if (rand.nextInt(5) == 2) {
                            chunkPrimerIn.func_177855_a(x2, y + 2, z2 + 1, GRAVEL);
                        }
                    }
                    if (rand.nextInt(300) == 3) {
                        for (int i2 = 0; i2 < ZGHelper.rngInt(1, 5); ++i2) {
                            IBlockState blockToUse = ZGHelper.getRNG().nextInt(5) == 1 ? DIRT : STONE;
                            chunkPrimerIn.func_177855_a(x2, y + i2, z2, blockToUse);
                        }
                    } else {
                        if (rand.nextInt(20) == 2) {
                            chunkPrimerIn.func_177855_a(x2, y + 1, z2, SEAWEED);
                        }
                        chunkPrimerIn.func_177855_a(x2, y, z2, DIRT);
                    }
                    if (rand.nextInt(1000) > 5) continue;
                    BlockPos chestPos = new BlockPos(x2, y + 1, z2);
                    int posX = chestPos.func_177958_n();
                    int posY = chestPos.func_177956_o();
                    int posZ = chestPos.func_177952_p();
                    IBlockState state = chunkPrimerIn.func_177856_a(posX, posY, posZ);
                    Block block = state.func_177230_c();
                    if (!ConfigManagerZG.enableAltumTreasureGen || chestPos == null || chestPos == null || block == null) continue;
                    OCEAN_TREASURE_GEN.func_180709_b(worldIn, rand, chestPos);
                    continue;
                }
                if (y < 74) continue;
                chunkPrimerIn.func_177855_a(x2, y, z2, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != ZGBlocks.altumStone) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (y >= i - 4 && y <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (y < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = WATER;
                }
                j = k;
                if (y >= i - 1) {
                    chunkPrimerIn.func_177855_a(x2, y, z2, topState);
                    continue;
                }
                if (y < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(x2, y, z2, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(x2, y, z2, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(x2, y, z2, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateAltumTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorAltum();
    }

    protected BiomeDecoratorAltum getBiomeDecorator() {
        return (BiomeDecoratorAltum)this.field_76760_I;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }

    public void addWaterSpawns() {
        this.clearAllSpawning();
        this.field_76755_L.add(new Biome.SpawnListEntry(EntitySquidlus.class, 75, 2, 4));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntitySquid.class, 70, 2, 4));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntityJellyfish.class, 65, 1, 4));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntityGypsyFish.class, 62, 4, 8));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntityBlubberFish.class, 60, 3, 6));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntityBladeFish.class, 55, 1, 3));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntityShark.class, 45, 1, 2));
        this.field_76755_L.add(new Biome.SpawnListEntry(EntityAbyssalVillager.class, 40, 1, 2));
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityAbyssalVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
    }
}

