/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import zollerngalaxy.biomes.ZGBiomeBase;
import zollerngalaxy.celestial.IZollernBody;
import zollerngalaxy.celestial.ZGMoon;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;

public class BiomeSpace
extends ZGBiomeBase {
    protected IZollernBody planetForBiome = null;
    protected WorldProviderPlanetZG spaceProvider = null;
    protected boolean enableExtremeMode = ConfigManagerZG.enableExtremeMode;
    protected int villagerSpawnRate = ConfigManagerZG.alienVillagerSpawnChance;
    protected int villagerMinSpawnRate = ConfigManagerZG.alienVillagerMinSpawnRate;
    protected int villagerMaxSpawnRate = ConfigManagerZG.alienVillagerMaxSpawnRate;
    public static int grassFoliageColor = 65280;
    protected static BiomeSpace INSTANCE;

    public BiomeSpace(Biome.BiomeProperties properties) {
        super(properties);
        INSTANCE = this;
        this.init();
    }

    public BiomeSpace(String biomeName) {
        super(new Biome.BiomeProperties(biomeName));
        INSTANCE = this;
        this.init();
    }

    public BiomeSpace(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        INSTANCE = this;
        this.init();
    }

    private void init() {
        int numSpawn = 4;
        int n = this.enableExtremeMode ? 2 : 1;
        this.clearAllSpawning();
        List monsterList = this.field_76761_J;
        monsterList.add(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 100, numSpawn *= n, numSpawn));
        monsterList.add(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 100, numSpawn, numSpawn));
        monsterList.add(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 100, numSpawn, numSpawn));
        monsterList.add(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 100, numSpawn, numSpawn));
        monsterList.add(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 100, numSpawn, numSpawn));
        monsterList.add(new Biome.SpawnListEntry(EntityEvolvedWitch.class, 100, numSpawn, numSpawn));
    }

    public static BiomeSpace instance() {
        return INSTANCE;
    }

    public BiomeSpace setPlanetForBiome(IZollernBody planet) {
        this.planetForBiome = planet;
        return this;
    }

    public BiomeSpace setBodyForBiome(IZollernBody planet) {
        this.setPlanetForBiome(planet);
        return this;
    }

    public BiomeSpace setMoonForBiome(ZGMoon moon) {
        this.setPlanetForBiome(moon);
        return this;
    }

    public IZollernBody getBodyForBiome() {
        return this.planetForBiome;
    }

    public BiomeSpace setSpaceProvider(WorldProviderPlanetZG provider) {
        this.spaceProvider = provider;
        return this;
    }

    public WorldProviderPlanetZG getSpaceProvider() {
        return this.spaceProvider;
    }

    public boolean getIsHotBiome() {
        return this.getBiomeTemp() >= 7.0f || this.getBodyForBiome().getIsHotBody();
    }

    public boolean getIsColdBiome() {
        return this.getBiomeTemp() <= 3.0f || this.getBodyForBiome().getIsColdBody();
    }

    public BiomeSpace setBlocks(Block topBlock, Block fillerBlock) {
        this.field_76752_A = topBlock.func_176223_P();
        this.field_76753_B = fillerBlock.func_176223_P();
        return this;
    }

    public BiomeSpace setTemp(float biomeTemp) {
        this.temp = biomeTemp;
        return this;
    }

    public float getBiomeTemp() {
        return this.temp;
    }

    public float getBodyTemp() {
        float planetTemp;
        IZollernBody planet = this.getBodyForBiome();
        float biomeTemp = this.getBiomeTemp();
        Random rand = new Random();
        float flucTemp = planetTemp = planet.getBodyTemperature();
        int tempChangeBy = this.enableExtremeMode ? 50 : 25;
        float maxTemp = planetTemp + (float)tempChangeBy;
        float minTemp = planetTemp - (float)tempChangeBy;
        flucTemp = planet.getIsColdBody() ? (flucTemp -= biomeTemp) : (planet.getIsHotBody() ? (flucTemp += biomeTemp) : planetTemp + biomeTemp);
        if (planetTemp < minTemp) {
            planetTemp = minTemp;
        }
        if (planetTemp > maxTemp) {
            planetTemp = maxTemp;
        }
        return flucTemp;
    }
}

