/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.api.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.creativetabs.ZGTabs;
import zollerngalaxy.lib.helpers.CommonZGRegisterHelper;
import zollerngalaxy.network.teleporter.MessageTeleportToDimension;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.ZGUtils;

public abstract class ItemCustomStarGate
extends Item {
    protected ZollernGalaxyCore core = ZollernGalaxyCore.instance();
    protected IProxy proxy = ZollernGalaxyCore.proxy;
    protected SimpleNetworkWrapper snw = ZollernGalaxyCore.snw;
    protected int toDimensionId = this.getNullId();
    protected int fromDimensionId = this.getNullId();

    public ItemCustomStarGate(int toDimensionIn, int fromDimensionIn) {
        this.setDimensions(toDimensionIn, fromDimensionIn);
        this.func_77625_d(1);
    }

    public Item setToDimensionId(int toDimensionIn) {
        this.toDimensionId = toDimensionIn;
        return this;
    }

    public Item setFromDimensionId(int fromDimensionIn) {
        this.fromDimensionId = fromDimensionIn;
        return this;
    }

    public Item setDimensions(int toDimensionIn, int fromDimensionIn) {
        this.setToDimensionId(toDimensionIn);
        this.setFromDimensionId(fromDimensionIn);
        return this;
    }

    public int getFromDimensionId() {
        return this.fromDimensionId;
    }

    public int getToDimensionId() {
        return this.toDimensionId;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return ZGTabs.zgItemsTab;
    }

    protected int getNullId() {
        return -1;
    }

    protected void teleportPlayer(World world, EntityPlayer player) {
        if (!ConfigManagerZG.disableStarGates) {
            if (this.getToDimensionId() != this.getNullId() && this.getFromDimensionId() != this.getNullId()) {
                this.sendToPlanet(player);
            } else {
                this.proxy.sendChatMessage(player, TextFormatting.DARK_RED + "Dimension IDs were invalid. Unable to teleport.");
            }
        } else {
            this.proxy.sendChatMessage(player, TextFormatting.DARK_RED + "Use of Star Gates has been disabled in the config.");
        }
    }

    protected void sendToPlanet(EntityPlayer player) {
        int toDim = this.getToDimensionId();
        int fromDim = this.getFromDimensionId();
        int playerDim = player.field_71093_bK;
        if (playerDim != toDim) {
            this.sendToServer(toDim, player);
        } else {
            this.sendToServer(fromDim, player);
        }
    }

    protected void sendToServer(int dimId, EntityPlayer player) {
        int playerId = player.func_145782_y();
        boolean canTP = true;
        if (canTP) {
            this.snw.sendToServer((IMessage)new MessageTeleportToDimension(dimId, playerId));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        this.teleportPlayer(worldIn, playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (CommonZGRegisterHelper.isShiftKeyDown()) {
            tooltip.add(TextFormatting.GREEN + ZGUtils.translate("tooltips.stargate"));
            tooltip.add(TextFormatting.GREEN + ZGUtils.translate("tooltips.stargate2"));
            tooltip.add(TextFormatting.GREEN + ZGUtils.translate("tooltips.stargate3"));
        } else {
            tooltip.add(TextFormatting.GOLD + ZGUtils.translate("tooltips.holdshift"));
        }
    }
}

