/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class TileEntityMultiblockPart<T extends TileEntityMultiblockPart<T>>
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IGeneralMultiblock {
    public boolean formed = false;
    public int field_174879_c = -1;
    public int[] offset = new int[]{0, 0, 0};
    public boolean mirrored = false;
    public EnumFacing facing = EnumFacing.NORTH;
    public long onlyLocalDissassembly = -1L;
    protected final int[] structureDimensions;

    protected TileEntityMultiblockPart(int[] structureDimensions) {
        this.structureDimensions = structureDimensions;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.formed = nbt.func_74767_n("formed");
        this.field_174879_c = nbt.func_74762_e("pos");
        this.offset = nbt.func_74759_k("offset");
        this.mirrored = nbt.func_74767_n("mirrored");
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74757_a("formed", this.formed);
        nbt.func_74768_a("pos", this.field_174879_c);
        nbt.func_74783_a("offset", this.offset);
        nbt.func_74757_a("mirrored", this.mirrored);
        nbt.func_74768_a("facing", this.facing.ordinal());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getAccessibleFluidTanks(facing).length > 0) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getAccessibleFluidTanks(facing).length > 0) {
            return (T)new MultiblockFluidWrapper(this, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    protected abstract IFluidTank[] getAccessibleFluidTanks(@Nullable EnumFacing var1);

    protected abstract boolean canFillTankFrom(int var1, EnumFacing var2, FluidStack var3);

    protected abstract boolean canDrainTankFrom(int var1, EnumFacing var2);

    public void func_145843_s() {
        super.func_145843_s();
    }

    public static boolean _Immovable() {
        return true;
    }

    @Nullable
    public T master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return (T)this;
        }
        BlockPos masterPos = this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return (T)(this.getClass().isInstance(te) ? (TileEntityMultiblockPart)te : null);
    }

    public void updateMasterBlock(IBlockState state, boolean blockUpdate) {
        T master = this.master();
        if (master != null) {
            master.func_70296_d();
            if (blockUpdate) {
                ((TileEntityIEBase)((Object)master)).markContainingBlockForUpdate(state);
            }
        }
    }

    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0 || this.offset[2] != 0;
    }

    @Override
    public boolean isLogicDummy() {
        return this.isDummy();
    }

    public abstract ItemStack getOriginalBlock();

    public void disassemble() {
        if (this.formed && !this.field_145850_b.field_72995_K) {
            BlockPos startPos = this.getOrigin();
            BlockPos masterPos = this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]);
            long time = this.field_145850_b.func_82737_E();
            for (int yy = 0; yy < this.structureDimensions[0]; ++yy) {
                for (int ll = 0; ll < this.structureDimensions[1]; ++ll) {
                    for (int ww = 0; ww < this.structureDimensions[2]; ++ww) {
                        IBlockState state;
                        int w = this.mirrored ? -ww : ww;
                        BlockPos pos = startPos.func_177967_a(this.facing, ll).func_177967_a(this.facing.func_176746_e(), w).func_177982_a(0, yy, 0);
                        ItemStack s = ItemStack.field_190927_a;
                        TileEntity te = this.field_145850_b.func_175625_s(pos);
                        if (te instanceof TileEntityMultiblockPart) {
                            TileEntityMultiblockPart part = (TileEntityMultiblockPart)te;
                            BlockPos diff = pos.func_177973_b((Vec3i)masterPos);
                            if (part.offset[0] != diff.func_177958_n() || part.offset[1] != diff.func_177956_o() || part.offset[2] != diff.func_177952_p()) continue;
                            if (time != part.onlyLocalDissassembly) {
                                s = part.getOriginalBlock();
                                part.formed = false;
                            }
                        }
                        if (pos.equals((Object)this.func_174877_v())) {
                            s = this.getOriginalBlock();
                        }
                        if ((state = Utils.getStateFromItemStack(s)) == null) continue;
                        if (pos.equals((Object)this.func_174877_v())) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, s));
                            continue;
                        }
                        this.replaceStructureBlock(pos, state, s, yy, ll, ww);
                    }
                }
            }
        }
    }

    public BlockPos getOrigin() {
        return this.getBlockPosForPos(0);
    }

    public BlockPos getBlockPosForPos(int targetPos) {
        int blocksPerLevel = this.structureDimensions[1] * this.structureDimensions[2];
        int distH = targetPos / blocksPerLevel - this.field_174879_c / blocksPerLevel;
        int distL = targetPos % blocksPerLevel / this.structureDimensions[2] - this.field_174879_c % blocksPerLevel / this.structureDimensions[2];
        int distW = targetPos % this.structureDimensions[2] - this.field_174879_c % this.structureDimensions[2];
        int w = this.mirrored ? -distW : distW;
        return this.func_174877_v().func_177967_a(this.facing, distL).func_177967_a(this.facing.func_176746_e(), w).func_177982_a(0, distH, 0);
    }

    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        if (state.func_177230_c() == this.func_145838_q()) {
            this.field_145850_b.func_175698_g(pos);
        }
        this.field_145850_b.func_175656_a(pos, state);
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.ITileDrop) {
            ((IEBlockInterfaces.ITileDrop)tile).readOnPlacement(null, stack);
        }
    }

    public static class MultiblockFluidWrapper
    implements IFluidHandler {
        final TileEntityMultiblockPart multiblock;
        final EnumFacing side;

        public MultiblockFluidWrapper(TileEntityMultiblockPart multiblock, EnumFacing side) {
            this.multiblock = multiblock;
            this.side = side;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (!this.multiblock.formed) {
                return new IFluidTankProperties[0];
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            IFluidTankProperties[] array = new IFluidTankProperties[tanks.length];
            for (int i = 0; i < tanks.length; ++i) {
                array[i] = new FluidTankProperties(tanks[i].getFluid(), tanks[i].getCapacity());
            }
            return array;
        }

        public int fill(FluidStack resource, boolean doFill) {
            IFluidTank tank;
            int i;
            if (!this.multiblock.formed || resource == null) {
                return 0;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            int fill = -1;
            for (i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canFillTankFrom(i, this.side, resource) && tank.getFluid() != null && tank.getFluid().isFluidEqual(resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
            }
            if (fill == -1) {
                for (i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canFillTankFrom(i, this.side, resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
                }
            }
            if (fill > 0) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return fill < 0 ? 0 : fill;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            IFluidTank tank;
            if (!this.multiblock.formed || resource == null) {
                return null;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            FluidStack drain = null;
            for (int i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canDrainTankFrom(i, this.side) && (drain = tank instanceof IFluidHandler ? ((IFluidHandler)tank).drain(resource, doDrain) : tank.drain(resource.amount, doDrain)) != null); ++i) {
            }
            if (drain != null) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return drain;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            IFluidTank tank;
            if (!this.multiblock.formed || maxDrain == 0) {
                return null;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            FluidStack drain = null;
            for (int i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canDrainTankFrom(i, this.side) && (drain = tank.drain(maxDrain, doDrain)) != null); ++i) {
            }
            if (drain != null) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return drain;
        }
    }
}

