/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.GuiSorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityFluidSorter;
import blusunrize.immersiveengineering.common.gui.ContainerFluidSorter;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class GuiFluidSorter
extends GuiIEContainerBase {
    public TileEntityFluidSorter tile;
    InventoryPlayer playerInventory;

    public GuiFluidSorter(InventoryPlayer inventoryPlayer, TileEntityFluidSorter tile) {
        super(new ContainerFluidSorter(inventoryPlayer, tile));
        this.tile = tile;
        this.playerInventory = inventoryPlayer;
        this.field_147000_g = 244;
    }

    @Override
    public void func_73863_a(int mx, int my, float partial) {
        super.func_73863_a(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiSorter.ButtonSorter) || mx <= button.field_146128_h || mx >= button.field_146128_h + 18 || my <= button.field_146129_i || my >= button.field_146129_i + 18) continue;
            int type = ((GuiSorter.ButtonSorter)button).type;
            String[] split = I18n.func_135052_a((String)"desc.immersiveengineering.info.filter.nbt", (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                tooltip.add((i == 0 ? TextFormatting.WHITE : TextFormatting.GRAY) + split[i]);
            }
        }
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                if (this.tile.filters[side][i] == null) continue;
                int x = this.field_147003_i + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.field_147009_r + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                if (mx <= x || mx >= x + 16 || my <= y || my >= y + 16) continue;
                ClientUtils.addFluidTooltip(this.tile.filters[side][i], tooltip, 0);
            }
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.field_146289_q, this.field_147003_i + this.field_146999_f, -1);
            RenderHelper.func_74520_c();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                int x = this.field_147003_i + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.field_147009_r + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                if (mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
                FluidStack fs = FluidUtil.getFluidContained((ItemStack)this.playerInventory.func_70445_o());
                this.setFluidInSlot(side, i, fs);
            }
        }
    }

    protected void func_146976_a(float f, int mx, int my) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int side = 0; side < 6; ++side) {
            ClientUtils.bindAtlas();
            for (int i = 0; i < 8; ++i) {
                TextureAtlasSprite sprite;
                if (this.tile.filters[side][i] == null || (sprite = ClientUtils.getSprite(this.tile.filters[side][i].getFluid().getStill(this.tile.filters[side][i]))) == null) continue;
                int x = this.field_147003_i + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.field_147009_r + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                int col = this.tile.filters[side][i].getFluid().getColor(this.tile.filters[side][i]);
                GlStateManager.func_179131_c((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
                ClientUtils.drawTexturedRect((float)x, (float)y, 16.0f, 16.0f, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h());
            }
            int x = this.field_147003_i + 30 + side / 2 * 58;
            int y = this.field_147009_r + 44 + side % 2 * 76;
            String s = I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide." + EnumFacing.func_82600_a((int)side).toString()), (Object[])new Object[0]).substring(0, 1);
            GlStateManager.func_179147_l();
            ClientUtils.font().func_175065_a(s, (float)(x - ClientUtils.font().func_78256_a(s) / 2), (float)y, -1429418804, true);
        }
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        for (int side = 0; side < 6; ++side) {
            int x = this.field_147003_i + 21 + side / 2 * 58;
            int y = this.field_147009_r + 3 + side % 2 * 76;
            GuiSorter.ButtonSorter b = new GuiSorter.ButtonSorter(side, x, y, 1);
            b.active = this.tile.doNBT(side);
            this.field_146292_n.add(b);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiSorter.ButtonSorter && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            int side = button.field_146127_k;
            this.tile.sortWithNBT[side] = (byte)(this.tile.sortWithNBT[side] != 1 ? 1 : 0);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74773_a("sideConfig", this.tile.sortWithNBT);
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
            this.func_73866_w_();
        }
    }

    public void setFluidInSlot(int side, int slot, FluidStack fluid) {
        this.tile.filters[side][slot] = fluid;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("filter_side", side);
        tag.func_74768_a("filter_slot", slot);
        if (fluid != null) {
            tag.func_74782_a("filter", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        }
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
    }
}

