/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.util.Tuple;
import omtteam.omlib.compatibility.OMLibModCompatibility;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.util.RandomUtil;
import omtteam.omlib.util.WorldUtil;
import omtteam.omlib.util.inventory.InvUtil;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.api.lists.MobBlacklist;
import omtteam.openmodularturrets.api.lists.MobList;
import omtteam.openmodularturrets.api.lists.NeutralList;
import omtteam.openmodularturrets.blocks.BlockBaseAttachment;
import omtteam.openmodularturrets.compatibility.ModCompatibility;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.handler.config.TurretSetting;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.items.AmmoMetaItem;
import omtteam.openmodularturrets.tileentity.Expander;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.OMTUtil;
import valkyrienwarfare.api.IPhysicsEntity;
import valkyrienwarfare.api.IPhysicsEntityManager;
import valkyrienwarfare.api.TransformType;

public class TurretHeadUtil {
    private static final HashMap<Tuple<Player, BlockPos>, Long> warnedPlayers = new HashMap();

    public static void warnPlayers(TurretBase base, World worldObj, BlockPos pos, int turretRange) {
        if (base.isAttacksPlayers()) {
            int warnDistance = OMTConfig.TURRETS.turretWarningDistance;
            AxisAlignedBB axis = new AxisAlignedBB((double)(pos.func_177958_n() - turretRange - warnDistance), (double)(pos.func_177956_o() - turretRange - warnDistance), (double)(pos.func_177952_p() - turretRange - warnDistance), (double)(pos.func_177958_n() + turretRange + warnDistance), (double)(pos.func_177956_o() + turretRange + warnDistance), (double)(pos.func_177952_p() + turretRange + warnDistance));
            List targets = worldObj.func_72872_a(EntityPlayerMP.class, axis);
            for (EntityPlayerMP target : targets) {
                Player player = new Player((EntityPlayer)target);
                Tuple entry = new Tuple((Object)player, (Object)base.func_174877_v());
                if (PlayerUtil.isPlayerOwner((Player)player, (IHasOwner)base) || PlayerUtil.isPlayerTrusted((Player)player, (IHasOwner)base) || target.field_71075_bZ.field_75098_d) continue;
                if (warnedPlayers.containsKey(entry) && warnedPlayers.get(entry) < worldObj.func_82737_E()) {
                    warnedPlayers.remove(entry);
                } else if (warnedPlayers.containsKey(entry)) continue;
                TurretHeadUtil.dispatchWarnMessage(target);
                warnedPlayers.put((Tuple<Player, BlockPos>)entry, worldObj.func_82737_E() + 12000L);
            }
        }
    }

    private static void dispatchWarnMessage(EntityPlayerMP player) {
        if (OMTConfig.TURRETS.turretAlarmSound) {
            player.func_184185_a(ModSounds.warningSound, 1.0f, 1.0f);
        }
        if (OMTConfig.TURRETS.turretWarnMessage) {
            PlayerUtil.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentTranslation("status.warning", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public static boolean isEntityValidNeutral(TurretBase base, EntityLivingBase possibleTarget) {
        if (base.isAttacksNeutrals() && OMTConfig.TURRETS.globalCanTargetNeutrals) {
            return !possibleTarget.field_70128_L && (possibleTarget instanceof EntityAnimal || possibleTarget instanceof EntityAmbientCreature || NeutralList.contains(possibleTarget));
        }
        return false;
    }

    public static boolean isEntityValidMob(TurretBase base, EntityLivingBase possibleTarget) {
        if (base.isAttacksMobs() && OMTConfig.TURRETS.globalCanTargetMobs) {
            return !possibleTarget.field_70128_L && (possibleTarget.isCreatureType(EnumCreatureType.MONSTER, false) || MobList.contains(possibleTarget));
        }
        return false;
    }

    public static Entity getTarget(TurretBase base, World worldObj, BlockPos pos, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null) {
            AxisAlignedBB axis = TurretHeadUtil.getTargetSearchingBox(pos, turretRange);
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase possibleTarget : targets) {
                EntityPlayer owner;
                Entity entity;
                if (possibleTarget != null && EntityList.func_75621_b((Entity)possibleTarget) != null && MobBlacklist.contains(EntityList.func_75621_b((Entity)possibleTarget)) || possibleTarget == null) continue;
                boolean validTarget = true;
                if (base.getController() != null && !base.getController().isEntityValidTarget((Entity)possibleTarget, TurretHeadUtil.getAimYaw((Entity)possibleTarget, pos), TurretHeadUtil.getAimPitch((Entity)possibleTarget, pos))) {
                    validTarget = false;
                }
                if (!validTarget || (!(possibleTarget instanceof IEntityOwnable) ? possibleTarget instanceof EntityHorse && ((EntityHorse)possibleTarget).func_110248_bS() : (entity = ((IEntityOwnable)possibleTarget).func_70902_q()) instanceof EntityPlayer && (PlayerUtil.isPlayerOwner((EntityPlayer)(owner = (EntityPlayer)entity), (IHasOwner)base) || PlayerUtil.isPlayerTrusted((EntityPlayer)owner, (IHasOwner)base)))) continue;
                if (TurretHeadUtil.isEntityValidNeutral(base, possibleTarget)) {
                    target = possibleTarget;
                }
                if (TurretHeadUtil.isEntityValidMob(base, possibleTarget)) {
                    target = possibleTarget;
                }
                if (base.isAttacksPlayers() && OMTConfig.TURRETS.globalCanTargetPlayers && possibleTarget instanceof EntityPlayerMP && !possibleTarget.field_70128_L && OMTUtil.canDamagePlayer((EntityPlayer)(entity = (EntityPlayerMP)possibleTarget), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = possibleTarget;
                }
                if (target == null || turret == null || base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, (Entity)target) || !TurretHeadUtil.canTurretSeeTarget(turret, target) || !(target.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    public static Entity getTargetWithMinimumRange(TurretBase base, World worldObj, BlockPos pos, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null) {
            AxisAlignedBB axis = TurretHeadUtil.getTargetSearchingBox(pos, turretRange);
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityPlayerMP entity;
                if (TurretHeadUtil.isEntityValidNeutral(base, target1) && target1.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) >= 3.0) {
                    target = target1;
                }
                if (TurretHeadUtil.isEntityValidMob(base, target1) && target1.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) >= 3.0) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && OMTConfig.TURRETS.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && target1.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) >= 3.0 && OMTUtil.canDamagePlayer((EntityPlayer)(entity = (EntityPlayerMP)target1), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null || base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, (Entity)target) || !TurretHeadUtil.canTurretSeeTarget(turret, target) || !(target.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    public static Entity getTargetWithoutSlowEffect(TurretBase base, World worldObj, BlockPos pos, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        Potion slownessPotion = Potion.func_188412_a((int)2);
        if (!worldObj.field_72995_K && base != null && slownessPotion != null) {
            AxisAlignedBB axis = TurretHeadUtil.getTargetSearchingBox(pos, turretRange);
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityPlayerMP entity;
                if (TurretHeadUtil.isEntityValidNeutral(base, target1) && !target1.func_70644_a(slownessPotion)) {
                    target = target1;
                }
                if (TurretHeadUtil.isEntityValidMob(base, target1) && !target1.func_70644_a(slownessPotion)) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && OMTConfig.TURRETS.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && !target1.func_70644_a(slownessPotion) && OMTUtil.canDamagePlayer((EntityPlayer)(entity = (EntityPlayerMP)target1), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null || base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, (Entity)target) || !TurretHeadUtil.canTurretSeeTarget(turret, target) || !(target.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    private static boolean isTargetAlreadyTargeted(TurretBase base, Entity entity) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)base.func_145831_w(), (BlockPos)base.func_174877_v())) {
            if (!(tileEntity instanceof TurretHead) || !entity.equals((Object)((TurretHead)tileEntity).target)) continue;
            return true;
        }
        return false;
    }

    public static int getPowerExpanderTotalExtraCapacity(World world, BlockPos pos) {
        int totalExtraCap = 0;
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)world, (BlockPos)pos)) {
            if (!(tileEntity instanceof Expander) || !((Expander)tileEntity).isPowerExpander()) continue;
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((Expander)tileEntity);
        }
        return totalExtraCap;
    }

    private static ItemStack deductFromInvExpander(ItemStack itemStack, Expander exp, TurretBase base, @Nullable TurretHead turretHead) {
        for (int i = 0; i < exp.getInventory().getSlots(); ++i) {
            ItemStack ammoCheck = exp.getInventory().getStackInSlot(i);
            if (ammoCheck == ItemStack.field_190927_a || ammoCheck.func_77973_b() != itemStack.func_77973_b()) continue;
            if (TurretHeadUtil.hasRecyclerAddon(base) && turretHead != null) {
                TurretSetting settings = turretHead.getTurretType().getSettings();
                float chance = RandomUtil.random.nextFloat() + 0.5f;
                if ((double)chance < settings.recyclerNegateChance) {
                    return new ItemStack(ammoCheck.func_77973_b());
                }
                if ((double)chance > settings.recyclerNegateChance && (double)chance < settings.recyclerNegateChance + settings.recyclerAddChance) {
                    exp.getInventory().insertItem(i, new ItemStack(ammoCheck.func_77973_b(), 1), false);
                    return new ItemStack(ammoCheck.func_77973_b());
                }
                exp.getInventory().extractItem(i, 1, false);
                return new ItemStack(ammoCheck.func_77973_b());
            }
            exp.getInventory().extractItem(i, 1, false);
            return new ItemStack(ammoCheck.func_77973_b());
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getSpecificItemFromInvExpanders(World world, ItemStack itemStack, TurretBase base, @Nullable TurretHead turretHead) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)world, (BlockPos)base.func_174877_v())) {
            Expander exp;
            ItemStack stack;
            if (!(tileEntity instanceof Expander) || ((Expander)tileEntity).isPowerExpander() || (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (Expander)tileEntity, base, turretHead)) == ItemStack.field_190927_a) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getDisposableAmmoFromInvExpander(World world, TurretBase base, TurretHead turretHead) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)world, (BlockPos)base.func_174877_v())) {
            if (!(tileEntity instanceof Expander) || ((Expander)tileEntity).isPowerExpander()) continue;
            Expander exp = (Expander)tileEntity;
            TurretSetting settings = turretHead.getTurretType().getSettings();
            for (int i = 0; i < exp.getInventory().getSlots(); ++i) {
                ItemStack itemCheck = exp.getInventory().getStackInSlot(i);
                if (itemCheck == ItemStack.field_190927_a || !OMTUtil.isItemStackValidAmmo(itemCheck) || itemCheck.func_77973_b() instanceof AmmoMetaItem) continue;
                if (TurretHeadUtil.hasRecyclerAddon(base)) {
                    float chance = RandomUtil.random.nextFloat() + 0.5f;
                    if ((double)chance < settings.recyclerNegateChance) {
                        return new ItemStack(itemCheck.func_77973_b());
                    }
                    if ((double)chance > settings.recyclerNegateChance && (double)chance < settings.recyclerNegateChance + settings.recyclerAddChance) {
                        exp.getInventory().insertItem(i, new ItemStack(itemCheck.func_77973_b(), 1), false);
                        return new ItemStack(itemCheck.func_77973_b());
                    }
                    exp.getInventory().extractItem(i, 1, false);
                    return new ItemStack(itemCheck.func_77973_b());
                }
                exp.getInventory().extractItem(i, 1, false);
                return new ItemStack(itemCheck.func_77973_b(), 1, itemCheck.func_77952_i());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getDisposableAmmoFromBase(TurretBase base, @Nullable TurretHead turretHead) {
        if (turretHead == null) {
            return ItemStack.field_190927_a;
        }
        TurretSetting settings = turretHead.getTurretType().getSettings();
        for (int i = 0; i <= 8; ++i) {
            ItemStack itemCheck = base.getInventory().getStackInSlot(i);
            if (itemCheck == ItemStack.field_190927_a || !OMTUtil.isItemStackValidAmmo(itemCheck) || itemCheck.func_77973_b() instanceof AmmoMetaItem) continue;
            if (TurretHeadUtil.hasRecyclerAddon(base)) {
                float chance = RandomUtil.random.nextFloat() + 0.5f;
                if ((double)chance < settings.recyclerNegateChance) {
                    return new ItemStack(itemCheck.func_77973_b());
                }
                if ((double)chance > settings.recyclerNegateChance && (double)chance < settings.recyclerNegateChance + settings.recyclerAddChance) {
                    base.getInventory().insertItem(i, new ItemStack(itemCheck.func_77973_b(), 1), false);
                    return new ItemStack(itemCheck.func_77973_b());
                }
                base.getInventory().extractItem(i, 1, false);
                return new ItemStack(itemCheck.func_77973_b());
            }
            base.getInventory().extractItem(i, 1, false);
            return new ItemStack(itemCheck.func_77973_b(), 1, itemCheck.func_77952_i());
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getSpecificItemStackFromBase(TurretBase base, ItemStack stack) {
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammo_stack = base.getInventory().getStackInSlot(i);
            if (ammo_stack == ItemStack.field_190927_a || InvUtil.getStackSize((ItemStack)ammo_stack) <= 0 || ammo_stack.func_77973_b() != stack.func_77973_b()) continue;
            base.getInventory().extractItem(i, 1, false);
            return new ItemStack(ammo_stack.func_77973_b());
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getSpecificItemStackFromBase(TurretBase base, ItemStack stack, TurretHead turretHead) {
        TurretSetting settings = turretHead.getTurretType().getSettings();
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammo_stack = base.getInventory().getStackInSlot(i);
            if (ammo_stack == ItemStack.field_190927_a || InvUtil.getStackSize((ItemStack)ammo_stack) <= 0 || ammo_stack.func_77973_b() != stack.func_77973_b() || ammo_stack.func_77960_j() != stack.func_77960_j()) continue;
            if (TurretHeadUtil.hasRecyclerAddon(base)) {
                float chance = RandomUtil.random.nextFloat() + 0.5f;
                if ((double)chance < settings.recyclerNegateChance) {
                    return new ItemStack(ammo_stack.func_77973_b());
                }
                if ((double)chance > settings.recyclerNegateChance && (double)chance < settings.recyclerNegateChance + settings.recyclerAddChance) {
                    base.getInventory().insertItem(i, new ItemStack(ammo_stack.func_77973_b(), 1), false);
                    return new ItemStack(ammo_stack.func_77973_b());
                }
                base.getInventory().extractItem(i, 1, false);
                return new ItemStack(ammo_stack.func_77973_b());
            }
            base.getInventory().extractItem(i, 1, false);
            return new ItemStack(ammo_stack.func_77973_b());
        }
        return ItemStack.field_190927_a;
    }

    public static int getAmmoLevel(TurretHead turret, TurretBase base) {
        int result = 0;
        ItemStack ammoStackRequired = turret.getAmmo();
        if (ammoStackRequired == null) {
            return base.getEnergyStored(EnumFacing.DOWN) / turret.getTurretBasePowerUsage();
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammoStack = base.getInventory().getStackInSlot(i);
            if (ammoStack == ItemStack.field_190927_a || InvUtil.getStackSize((ItemStack)ammoStack) <= 0 || ammoStack.func_77973_b() != ammoStackRequired.func_77973_b() || ammoStack.func_77960_j() != ammoStackRequired.func_77960_j()) continue;
            result += ammoStack.func_190916_E();
        }
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)base.func_145831_w(), (BlockPos)base.func_174877_v())) {
            if (!(tileEntity instanceof Expander) || ((Expander)tileEntity).isPowerExpander()) continue;
            Expander exp = (Expander)tileEntity;
            for (int i = 0; i < exp.getInventory().getSlots(); ++i) {
                ItemStack ammoStack = exp.getInventory().getStackInSlot(i);
                if (ammoStack == ItemStack.field_190927_a || ammoStack.func_77973_b() != ammoStackRequired.func_77973_b()) continue;
                result += ammoStack.func_190916_E();
            }
        }
        return result;
    }

    private static int getPowerExtenderCapacityValue(Expander expander) {
        if (expander != null) {
            if (!expander.isPowerExpander()) {
                return 0;
            }
            int tier = expander.getTier() > 4 ? expander.getTier() - 4 : 0;
            switch (tier) {
                case 1: {
                    return OMTConfig.MISCELLANEOUS.expanderPowerTierOneCapacity;
                }
                case 2: {
                    return OMTConfig.MISCELLANEOUS.expanderPowerTierTwoCapacity;
                }
                case 3: {
                    return OMTConfig.MISCELLANEOUS.expanderPowerTierThreeCapacity;
                }
                case 4: {
                    return OMTConfig.MISCELLANEOUS.expanderPowerTierFourCapacity;
                }
                case 5: {
                    return OMTConfig.MISCELLANEOUS.expanderPowerTierFiveCapacity;
                }
            }
            return 0;
        }
        return 0;
    }

    public static TurretBase getTurretBase(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            if (!(world.func_175625_s(offsetPos) instanceof TurretBase)) continue;
            return (TurretBase)world.func_175625_s(offsetPos);
        }
        return null;
    }

    public static EnumFacing getTurretBaseFacing(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            if (!(world.func_175625_s(offsetPos) instanceof TurretBase)) continue;
            return facing;
        }
        return null;
    }

    public static Map<EnumFacing, TurretHead> getBaseTurrets(IBlockAccess world, BlockPos pos) {
        HashMap<EnumFacing, TurretHead> map = new HashMap<EnumFacing, TurretHead>();
        if (world == null) {
            return map;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            if (!(world.func_175625_s(offsetPos) instanceof TurretHead)) continue;
            map.put(facing, (TurretHead)world.func_175625_s(offsetPos));
        }
        return map;
    }

    public static float getAimYaw(Entity target, BlockPos pos) {
        IPhysicsEntity physicsEntity;
        Vec3d targetPos = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(target.func_130014_f_(), pos)) != null) {
            targetPos = physicsEntity.transformVector(targetPos, TransformType.GLOBAL_TO_SUBSPACE);
        }
        double dX = targetPos.field_72450_a - (double)pos.func_177958_n();
        double dZ = targetPos.field_72449_c - (double)pos.func_177952_p();
        float yaw = (float)Math.atan2(dZ, dX);
        if (yaw < 0.0f) {
            yaw = (float)((double)yaw + Math.PI * 2);
        }
        return yaw / (float)Math.PI * 180.0f;
    }

    public static float getAimPitch(Entity target, BlockPos pos) {
        IPhysicsEntity physicsEntity;
        Vec3d targetPos = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(target.func_130014_f_(), pos)) != null) {
            targetPos = physicsEntity.transformVector(targetPos, TransformType.GLOBAL_TO_SUBSPACE);
        }
        BlockPos targetBlockPos = new BlockPos(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c);
        double dX = (float)targetBlockPos.func_177958_n() - 0.5f - ((float)pos.func_177958_n() + 0.5f);
        double dY = (float)targetBlockPos.func_177956_o() + 0.5f - ((float)pos.func_177956_o() - 0.5f);
        double dZ = (float)targetBlockPos.func_177952_p() - 0.5f - ((float)pos.func_177952_p() + 0.5f);
        float pitch = (float)Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY);
        if (pitch < 0.0f) {
            pitch = (float)((double)pitch + Math.PI * 2);
        }
        return pitch / (float)Math.PI * 180.0f;
    }

    public static int getRangeUpgrades(TurretBase base, TurretHead turretHead) {
        int value = 0;
        int tier = base.getTier();
        if (tier == 1) {
            return value;
        }
        if (tier == 5 && base.getInventory().getStackInSlot(12) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(12).func_77952_i() == 3) {
            value += turretHead.getTurretType().getSettings().rangeUpgrade * InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(12));
        }
        if (base.getInventory().getStackInSlot(11) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(11).func_77952_i() == 3) {
            value += turretHead.getTurretType().getSettings().rangeUpgrade * InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(11));
        }
        return value;
    }

    public static int getScattershotUpgrades(TurretBase base) {
        int value = 0;
        int tier = base.getTier();
        if (tier == 1) {
            return value;
        }
        if (tier == 5 && base.getInventory().getStackInSlot(12) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(12).func_77952_i() == 4) {
            value += InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(12));
        }
        if (base.getInventory().getStackInSlot(11) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(11).func_77952_i() == 4) {
            value += InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(11));
        }
        return value;
    }

    public static float getAccuracyUpgrades(TurretBase base, TurretHead turretHead) {
        float accuracy = 0.0f;
        int tier = base.getTier();
        if (tier == 1) {
            return accuracy;
        }
        if (tier == 5 && base.getInventory().getStackInSlot(12) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(12).func_77952_i() == 0) {
            accuracy = (float)((double)accuracy + turretHead.getTurretType().getSettings().accuracyUpgrade * (double)InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(12)));
        }
        if (base.getInventory().getStackInSlot(11) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(11).func_77952_i() == 0) {
            accuracy = (float)((double)accuracy + turretHead.getTurretType().getSettings().accuracyUpgrade * (double)InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(11)));
        }
        return accuracy;
    }

    public static float getEfficiencyUpgrades(TurretBase base, TurretHead turretHead) {
        float efficiency = 0.0f;
        int tier = base.getTier();
        if (tier == 1) {
            return efficiency;
        }
        if (tier == 5 && base.getInventory().getStackInSlot(12) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(12).func_77952_i() == 1) {
            efficiency = (float)((double)efficiency + turretHead.getTurretType().getSettings().efficiencyUpgrade * (double)InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(12)));
        }
        if (base.getInventory().getStackInSlot(11) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(11).func_77952_i() == 1) {
            efficiency = (float)((double)efficiency + turretHead.getTurretType().getSettings().efficiencyUpgrade * (double)InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(11)));
        }
        return efficiency;
    }

    public static float getFireRateUpgrades(TurretBase base, TurretHead turretHead) {
        float rof = 0.0f;
        int tier = base.getTier();
        if (tier == 1) {
            return rof;
        }
        if (tier == 5 && base.getInventory().getStackInSlot(12) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(12).func_77952_i() == 2) {
            rof = (float)((double)rof + turretHead.getTurretType().getSettings().fireRateUpgrade * (double)InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(12)));
        }
        if (base.getInventory().getStackInSlot(11) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(11).func_77952_i() == 2) {
            rof = (float)((double)rof + turretHead.getTurretType().getSettings().fireRateUpgrade * (double)InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(11)));
        }
        return rof;
    }

    public static boolean hasRedstoneReactor(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a) {
            boolean bl = found = base.getInventory().getStackInSlot(9).func_77952_i() == 4;
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && !found) {
            found = base.getInventory().getStackInSlot(10).func_77952_i() == 4;
        }
        return found;
    }

    public static boolean hasDamageAmpAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a) {
            boolean bl = found = base.getInventory().getStackInSlot(9).func_77952_i() == 1;
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && !found) {
            found = base.getInventory().getStackInSlot(10).func_77952_i() == 1;
        }
        return found;
    }

    public static boolean hasConcealmentAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a) {
            boolean bl = found = base.getInventory().getStackInSlot(9).func_77952_i() == 0;
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && !found) {
            found = base.getInventory().getStackInSlot(10).func_77952_i() == 0;
        }
        return found || OMTConfig.TURRETS.canTurretsConcealWithoutAddon;
    }

    public static boolean hasSolarPanelAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a) {
            boolean bl = found = base.getInventory().getStackInSlot(9).func_77952_i() == 6;
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && !found) {
            found = base.getInventory().getStackInSlot(10).func_77952_i() == 6;
        }
        return found;
    }

    public static boolean hasSerialPortAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (!OMLibModCompatibility.OpenComputersLoaded && !OMLibModCompatibility.ComputerCraftLoaded) {
            return false;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a) {
            boolean bl = found = base.getInventory().getStackInSlot(9).func_77952_i() == 5;
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && !found) {
            found = base.getInventory().getStackInSlot(10).func_77952_i() == 5;
        }
        return found;
    }

    private static boolean hasRecyclerAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a) {
            boolean bl = found = base.getInventory().getStackInSlot(9).func_77952_i() == 3;
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && !found) {
            found = base.getInventory().getStackInSlot(10).func_77952_i() == 3;
        }
        return found;
    }

    public static int getAmpLevel(TurretBase base) {
        int amp_level = 0;
        if (base == null) {
            return amp_level;
        }
        int tier = base.getTier();
        if (tier == 1) {
            return amp_level;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(9).func_77952_i() == 1) {
            amp_level += InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(9));
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(10).func_77952_i() == 1) {
            amp_level += InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(10));
        }
        return amp_level;
    }

    public static int getFakeDropsLevel(TurretBase base) {
        int fakeDropsLevel = -1;
        if (base == null) {
            return fakeDropsLevel;
        }
        int tier = base.getTier();
        if (tier == 1) {
            return fakeDropsLevel;
        }
        if (base.getInventory().getStackInSlot(9) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(9).func_77952_i() == 7) {
            fakeDropsLevel += InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(9));
        }
        if (base.getInventory().getStackInSlot(10) != ItemStack.field_190927_a && base.getInventory().getStackInSlot(10).func_77952_i() == 7) {
            fakeDropsLevel += InvUtil.getStackSize((ItemStack)base.getInventory().getStackInSlot(10));
        }
        return Math.min(fakeDropsLevel, 3);
    }

    public static boolean baseHasNoLootDeleter(TurretBase base) {
        ArrayList states = WorldUtil.getTouchingBlockStates((World)base.func_145831_w(), (BlockPos)base.func_174877_v());
        for (IBlockState state : states) {
            if (!(state.func_177230_c() instanceof BlockBaseAttachment) || (Integer)state.func_177229_b((IProperty)BlockBaseAttachment.BASE_ADDON_META) != 0) continue;
            return false;
        }
        return true;
    }

    public static void updateSolarPanelAddon(TurretBase base) {
        OMEnergyStorage storage = (OMEnergyStorage)base.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (!TurretHeadUtil.hasSolarPanelAddon(base) || storage == null) {
            return;
        }
        if (base.func_145831_w().func_72935_r() && !base.func_145831_w().func_72896_J() && base.func_145831_w().func_175710_j(base.func_174877_v().func_177981_b(2))) {
            storage.receiveEnergy(OMTConfig.MISCELLANEOUS.solarPanelAddonGen, false);
        }
    }

    public static boolean canTurretSeeTarget(TurretHead turret, EntityLivingBase target) {
        IPhysicsEntity physicsEntity;
        Vec3d traceStart = new Vec3d((double)((float)turret.func_174877_v().func_177958_n() + 0.5f), (double)((float)turret.func_174877_v().func_177956_o() + 0.5f), (double)((float)turret.func_174877_v().func_177952_p() + 0.5f));
        if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(turret.func_145831_w(), turret.func_174877_v())) != null) {
            traceStart = physicsEntity.transformVector(traceStart, TransformType.SUBSPACE_TO_GLOBAL);
        }
        Vec3d traceEnd = new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
        Vec3d vecDelta = new Vec3d(traceEnd.field_72450_a - traceStart.field_72450_a, traceEnd.field_72448_b - traceStart.field_72448_b, traceEnd.field_72449_c - traceStart.field_72449_c);
        vecDelta = vecDelta.func_72432_b();
        for (int i = 0; i < 10; ++i) {
            RayTraceResult traced;
            block6: {
                block5: {
                    traceStart = traceStart.func_178787_e(vecDelta);
                    traced = turret.func_145831_w().func_72933_a(traceStart, traceEnd);
                    if (traced == null || traced.field_72313_a != RayTraceResult.Type.BLOCK) break block5;
                    IBlockState hitBlock = turret.func_145831_w().func_180495_p(traced.func_178782_a());
                    if (traced.func_178782_a().equals((Object)turret.func_174877_v()) || !hitBlock.func_185904_a().func_76220_a() && MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(traceStart.field_72450_a - traceEnd.field_72450_a), (double)(traceStart.field_72448_b - traceEnd.field_72448_b)), (double)(traceStart.field_72449_c - traceEnd.field_72449_c)) > 1.0) break block6;
                }
                EntityLivingBase targeted = traced == null ? target : null;
                return targeted != null;
            }
            traceStart = traced.field_72307_f;
        }
        return false;
    }

    public static AxisAlignedBB getTargetSearchingBox(BlockPos pos, int turretRange) {
        return new AxisAlignedBB((double)(pos.func_177958_n() - turretRange - 1), (double)(pos.func_177956_o() - turretRange - 1), (double)(pos.func_177952_p() - turretRange - 1), (double)(pos.func_177958_n() + turretRange + 1), (double)(pos.func_177956_o() + turretRange + 1), (double)(pos.func_177952_p() + turretRange + 1));
    }
}

