/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.malisis.core.block.IComponent;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.renderer.IAnimatedRenderable;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.component.AnimatedModelComponent;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.Point;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AnimatedRenderer
extends MalisisRenderer<TileEntity> {
    private static Map<BlockPos, IAnimatedRenderable> animatedRenderables = Maps.newHashMap();
    IAnimatedRenderable renderable;

    public AnimatedRenderer() {
        this.registerForRenderWorldLast();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public IAnimatedRenderable getRenderable() {
        return this.renderable;
    }

    @Override
    public boolean shouldRender(RenderWorldLastEvent event, IBlockAccess world) {
        return animatedRenderables.size() > 0;
    }

    @Override
    public void render() {
        Point viewOffset = EntityUtils.getRenderViewOffset(this.partialTick);
        Frustum camera = new Frustum();
        this.renderType = RenderType.ANIMATED;
        animatedRenderables.values().stream().filter(arg_0 -> AnimatedRenderer.lambda$render$0((ICamera)camera, arg_0)).sorted((r1, r2) -> -BlockPosUtils.compare(viewOffset, r1.getPos(), r2.getPos())).forEach(this::renderRenderable);
        this.renderType = RenderType.WORLD_LAST;
    }

    private void renderRenderable(IAnimatedRenderable renderable) {
        this.renderable = renderable;
        this.set(renderable.getWorld(), renderable.getPos());
        this.posOffset = new Vec3d((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
        renderable.renderAnimated(this.block, this);
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        animatedRenderables.keySet().removeIf(p -> p.func_177958_n() >> 4 == event.getChunk().field_76635_g && p.func_177952_p() >> 4 == event.getChunk().field_76647_h);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        animatedRenderables.clear();
    }

    public static CallbackResult<Void> removeRenderable(Chunk chunk, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return CallbackResult.noResult();
        }
        if (!chunk.func_177412_p().field_72995_K) {
            return CallbackResult.noResult();
        }
        AnimatedModelComponent comp = IComponent.getComponent(AnimatedModelComponent.class, oldState.func_177230_c());
        if (comp != null) {
            animatedRenderables.remove(pos);
        }
        return CallbackResult.noResult();
    }

    public static Optional<IAnimatedRenderable> getRenderable(BlockPos pos) {
        return Optional.ofNullable(animatedRenderables.get(pos));
    }

    public static void registerRenderable(IBlockAccess world, BlockPos pos, AnimatedModelComponent amc) {
        IAnimatedRenderable r = animatedRenderables.get(pos);
        if (r == null) {
            animatedRenderables.put(pos, amc.createRenderable(world, pos));
        }
    }

    private static /* synthetic */ boolean lambda$render$0(ICamera camera, IAnimatedRenderable r) {
        return r.inFrustrum(camera);
    }

    static {
        MalisisRegistry.onPostSetBlock(AnimatedRenderer::removeRenderable, ICallback.CallbackOption.of());
    }
}

