/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import java.util.Random;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.init.NetherExItems;
import logictechcorp.netherex.init.NetherExMobEffects;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="netherex")
public class InputHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onMouse(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.isButtonstate() && player.func_70644_a(NetherExMobEffects.FROZEN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        EnumHand hand = event.getHand();
        if (stack.func_77973_b() instanceof ItemSpade) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            IBlockState flattenedBlock = null;
            if (block == Blocks.field_150424_aL) {
                flattenedBlock = NetherExBlocks.NETHERRACK_PATH.func_176223_P();
            } else if (block == NetherExBlocks.GLOOMY_NETHERRACK) {
                flattenedBlock = NetherExBlocks.GLOOMY_NETHERRACK_PATH.func_176223_P();
            } else if (block == NetherExBlocks.LIVELY_NETHERRACK) {
                flattenedBlock = NetherExBlocks.LIVELY_NETHERRACK_PATH.func_176223_P();
            } else if (block == NetherExBlocks.FIERY_NETHERRACK) {
                flattenedBlock = NetherExBlocks.FIERY_NETHERRACK_PATH.func_176223_P();
            } else if (block == NetherExBlocks.ICY_NETHERRACK) {
                flattenedBlock = NetherExBlocks.ICY_NETHERRACK_PATH.func_176223_P();
            }
            if (flattenedBlock != null) {
                player.func_184609_a(hand);
                world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, flattenedBlock, 11);
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos offsetPos;
        IBlockState offsetState;
        World world = event.getWorld();
        EnumFacing facing = event.getFace();
        BlockPos originalPos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        if (facing != null && (offsetState = world.func_180495_p(offsetPos = originalPos.func_177972_a(facing))).func_177230_c() == NetherExBlocks.BLUE_FIRE) {
            world.func_180498_a(player, 1009, offsetPos, 0);
            world.func_175698_g(offsetPos);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBoneMealUse(BonemealEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        IBlockState state = event.getBlock();
        Block block = state.func_177230_c();
        if (player.func_184614_ca().func_77973_b() == NetherExItems.WITHER_DUST) {
            if (block == NetherExBlocks.BROWN_ELDER_MUSHROOM || block == NetherExBlocks.RED_ELDER_MUSHROOM) {
                IGrowable growable;
                if (block instanceof IGrowable && (growable = (IGrowable)state.func_177230_c()).func_176473_a(world, pos, state, world.field_72995_K)) {
                    growable.func_176474_b(world, world.field_73012_v, pos, state);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        Random random = world.field_73012_v;
        if (entity instanceof EntityPigZombie) {
            EntityPigZombie zombiePigman = (EntityPigZombie)entity;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() == NetherExItems.GHAST_QUEEN_TEAR && stack.func_77960_j() == 0 && zombiePigman.func_70644_a(MobEffects.field_76437_t)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (!world.field_72995_K) {
                    int conversionTime = random.nextInt(2401) + 3600;
                    zombiePigman.getEntityData().func_74768_a("ConversionTime", conversionTime);
                    zombiePigman.func_184589_d(MobEffects.field_76437_t);
                    zombiePigman.func_70690_d(new PotionEffect(MobEffects.field_76420_g, conversionTime, Math.min(world.func_175659_aa().func_151525_a() - 1, 0)));
                }
            }
        }
    }
}

