/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public abstract class PipeEventItem
extends PipeEvent {
    public final IFlowItems flow;

    protected PipeEventItem(IPipeHolder holder, IFlowItems flow) {
        super(holder);
        this.flow = flow;
    }

    @Deprecated
    protected PipeEventItem(boolean canBeCancelled, IPipeHolder holder, IFlowItems flow) {
        super(canBeCancelled, holder);
        this.flow = flow;
    }

    public static class ItemEntry {
        public final EnumDyeColor colour;
        @Nonnull
        public final ItemStack stack;
        public final EnumFacing from;
        @Nullable
        public List<EnumFacing> to;

        public ItemEntry(EnumDyeColor colour, @Nonnull ItemStack stack, EnumFacing from) {
            this.colour = colour;
            this.stack = stack;
            this.from = from;
        }
    }

    public static class ModifySpeed
    extends PipeEventItem {
        public final ItemEntry item;
        public final double currentSpeed;
        public double targetSpeed = 0.0;
        public double maxSpeedChange = 0.0;

        public ModifySpeed(IPipeHolder holder, IFlowItems flow, ItemEntry item, double initSpeed) {
            super(holder, flow);
            this.item = item;
            this.currentSpeed = initSpeed;
        }

        public void modifyTo(double target, double maxDelta) {
            this.targetSpeed = target;
            this.maxSpeedChange = maxDelta;
        }
    }

    public static class FindDest
    extends OrderedEvent {
        public final ImmutableList<ItemEntry> items;

        public FindDest(IPipeHolder holder, IFlowItems flow, List<EnumSet<EnumFacing>> orderedDestinations, ImmutableList<ItemEntry> items) {
            super(holder, flow, orderedDestinations);
            this.items = items;
        }
    }

    public static class Split
    extends OrderedEvent {
        public final List<ItemEntry> items = new ArrayList<ItemEntry>();

        public Split(IPipeHolder holder, IFlowItems flow, List<EnumSet<EnumFacing>> order, ItemEntry toSplit) {
            super(holder, flow, order);
            this.items.add(toSplit);
        }
    }

    public static abstract class OrderedEvent
    extends PipeEventItem {
        public final List<EnumSet<EnumFacing>> orderedDestinations;

        public OrderedEvent(IPipeHolder holder, IFlowItems flow, List<EnumSet<EnumFacing>> orderedDestinations) {
            super(holder, flow);
            this.orderedDestinations = orderedDestinations;
        }

        public EnumSet<EnumFacing> getAllPossibleDestinations() {
            EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
            for (EnumSet<EnumFacing> e : this.orderedDestinations) {
                set.addAll(e);
            }
            return set;
        }

        public ImmutableList<EnumFacing> generateRandomOrder() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (EnumSet<EnumFacing> set : this.orderedDestinations) {
                ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>(set);
                Collections.shuffle(faces);
                builder.addAll(faces);
            }
            return builder.build();
        }
    }

    public static class Drop
    extends PipeEventItem {
        private final EntityItem entity;

        public Drop(IPipeHolder holder, IFlowItems flow, EntityItem entity) {
            super(holder, flow);
            this.entity = entity;
        }

        @Nonnull
        public ItemStack getStack() {
            ItemStack item = this.entity.func_92059_d();
            return item.func_190926_b() ? ItemStack.field_190927_a : item;
        }

        public void setStack(ItemStack stack) {
            if (stack == null) {
                throw new NullPointerException("stack");
            }
            if (stack.func_190926_b()) {
                this.entity.func_92058_a(ItemStack.field_190927_a);
            } else {
                this.entity.func_92058_a(stack);
            }
        }

        public EntityItem getEntity() {
            return this.entity;
        }
    }

    public static class TryBounce
    extends PipeEventItem {
        public final EnumDyeColor colour;
        public final EnumFacing from;
        @Nonnull
        public final ItemStack stack;
        public boolean canBounce = false;

        public TryBounce(IPipeHolder holder, IFlowItems flow, EnumDyeColor colour, EnumFacing from, @Nonnull ItemStack stack) {
            super(holder, flow);
            this.colour = colour;
            this.from = from;
            this.stack = stack;
        }
    }

    public static class SideCheck
    extends PipeEventItem {
        public final EnumDyeColor colour;
        public final EnumFacing from;
        @Nonnull
        public final ItemStack stack;
        private final int[] priority = new int[6];
        private final EnumSet<EnumFacing> allowed = EnumSet.allOf(EnumFacing.class);

        public SideCheck(IPipeHolder holder, IFlowItems flow, EnumDyeColor colour, EnumFacing from, @Nonnull ItemStack stack) {
            super(holder, flow);
            this.colour = colour;
            this.from = from;
            this.stack = stack;
        }

        public boolean isAllowed(EnumFacing side) {
            return this.allowed.contains(side);
        }

        public void disallow(EnumFacing ... sides) {
            for (EnumFacing side : sides) {
                this.allowed.remove(side);
            }
        }

        public void disallowAll(Collection<EnumFacing> sides) {
            this.allowed.removeAll(sides);
        }

        public void disallowAllExcept(EnumFacing ... sides) {
            this.allowed.retainAll(Lists.newArrayList((Object[])sides));
        }

        public void disallowAll() {
            this.allowed.clear();
        }

        public void increasePriority(EnumFacing side) {
            this.increasePriority(side, 1);
        }

        public void increasePriority(EnumFacing side, int by) {
            int n = side.ordinal();
            this.priority[n] = this.priority[n] - by;
        }

        public void decreasePriority(EnumFacing side) {
            this.decreasePriority(side, 1);
        }

        public void decreasePriority(EnumFacing side, int by) {
            this.increasePriority(side, -by);
        }

        public List<EnumSet<EnumFacing>> getOrder() {
            block8: {
                switch (this.allowed.size()) {
                    case 0: {
                        return ImmutableList.of();
                    }
                    case 1: {
                        return ImmutableList.of(this.allowed);
                    }
                }
                int val = this.priority[0];
                for (int i = 1; i < this.priority.length; ++i) {
                    if (this.priority[i] == val) {
                        continue;
                    }
                    break block8;
                }
                return ImmutableList.of(this.allowed);
            }
            int[] ordered = Arrays.copyOf(this.priority, 6);
            Arrays.sort(ordered);
            int last = 0;
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < 6; ++i) {
                int current = ordered[i];
                if (i != 0 && current == last) continue;
                last = current;
                EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    if (!this.allowed.contains(face) || this.priority[face.ordinal()] != current) continue;
                    set.add(face);
                }
                if (set.size() <= 0) continue;
                list.add(set);
            }
            return list;
        }
    }

    public static abstract class Ejected
    extends PipeEventItem {
        public final ItemStack inserted;
        @Nonnull
        private ItemStack excess;
        public final EnumFacing to;

        protected Ejected(IPipeHolder holder, IFlowItems flow, ItemStack inserted, ItemStack excess, EnumFacing to) {
            super(holder, flow);
            this.inserted = inserted;
            this.excess = excess;
            this.to = to;
        }

        @Nonnull
        public ItemStack getExcess() {
            return this.excess;
        }

        public void setExcess(ItemStack stack) {
            if (stack == null) {
                throw new NullPointerException("stack");
            }
            this.excess = stack;
        }

        public static class IntoTile
        extends Ejected {
            public final TileEntity tile;

            public IntoTile(IPipeHolder holder, IFlowItems flow, ItemStack inserted, ItemStack excess, EnumFacing to, TileEntity tile) {
                super(holder, flow, inserted, excess, to);
                this.tile = tile;
            }
        }

        public static class IntoPipe
        extends Ejected {
            public final IFlowItems otherPipe;

            public IntoPipe(IPipeHolder holder, IFlowItems flow, ItemStack inserted, ItemStack excess, EnumFacing to, IFlowItems otherPipe) {
                super(holder, flow, inserted, excess, to);
                this.otherPipe = otherPipe;
            }
        }
    }

    public static class ReachEnd
    extends ReachDest {
        public final EnumFacing to;

        public ReachEnd(IPipeHolder holder, IFlowItems flow, EnumDyeColor colour, @Nonnull ItemStack stack, EnumFacing to) {
            super(holder, flow, colour, stack);
            this.to = to;
        }
    }

    public static class ReachCenter
    extends ReachDest {
        public final EnumFacing from;

        public ReachCenter(IPipeHolder holder, IFlowItems flow, EnumDyeColor colour, @Nonnull ItemStack stack, EnumFacing from) {
            super(holder, flow, colour, stack);
            this.from = from;
        }
    }

    public static class OnInsert
    extends ReachDest {
        public final EnumFacing from;

        public OnInsert(IPipeHolder holder, IFlowItems flow, EnumDyeColor colour, @Nonnull ItemStack stack, EnumFacing from) {
            super(holder, flow, colour, stack);
            this.from = from;
        }
    }

    public static abstract class ReachDest
    extends PipeEventItem {
        public EnumDyeColor colour;
        @Nonnull
        private ItemStack stack;

        public ReachDest(IPipeHolder holder, IFlowItems flow, EnumDyeColor colour, @Nonnull ItemStack stack) {
            super(holder, flow);
            this.colour = colour;
            this.stack = stack;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            if (stack == null) {
                throw new NullPointerException("stack");
            }
            this.stack = stack;
        }
    }

    public static class TryInsert
    extends PipeEventItem {
        public final EnumDyeColor colour;
        public final EnumFacing from;
        @Nonnull
        public final ItemStack attempting;
        public int accepted;

        public TryInsert(IPipeHolder holder, IFlowItems flow, EnumDyeColor colour, EnumFacing from, @Nonnull ItemStack attempting) {
            super(true, holder, flow);
            this.colour = colour;
            this.from = from;
            this.attempting = attempting;
            this.accepted = attempting.func_190916_E();
        }

        @Override
        public void cancel() {
            super.cancel();
        }
    }
}

