/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.satellites.jupiter.dimension;

import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.planets.ceres.world.gen.BiomeProviderCeres;
import galaxyspace.systems.SolarSystem.satellites.jupiter.dimension.ChunkProviderJupiterSS;
import galaxyspace.systems.SolarSystem.satellites.mars.dimension.sky.SkyProviderMarsSS;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderJupiterSS
extends WorldProviderSpaceStation
implements IOrbitDimension,
IZeroGDimension,
ISolarLevel,
IExitHeight {
    Set<Entity> freefallingEntities = new HashSet<Entity>();

    public boolean shouldForceRespawn() {
        return false;
    }

    public DimensionType func_186058_p() {
        return GSDimensions.JUPITER_SS;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 48000L;
    }

    public boolean isDaytime() {
        float a = this.field_76579_a.func_72826_c(0.0f);
        return a < 0.42f || a > 0.58f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 64;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.jupiterSpaceStation;
    }

    public float getGravity() {
        return 0.075f;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderJupiterSS.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return BiomeProviderCeres.class;
    }

    public String getPlanetToOrbit() {
        return "ceres";
    }

    public int getYCoordToTeleportToPlanet() {
        return -500;
    }

    public String getSaveFolder() {
        return "DIM_SPACESTATION" + this.getDimension();
    }

    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getCelestialBody() instanceof IChildBody ? (double)this.getSolarSizeForMoon() : (double)this.getSolarSize();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    public float getSolarSizeForMoon() {
        return 1.0f / ((Moon)this.getCelestialBody()).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public double getYCoordinateToTeleport() {
        return 1000.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > 2;
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public boolean inFreefall(Entity entity) {
        return this.freefallingEntities.contains(entity);
    }

    public void setInFreefall(Entity entity) {
        this.freefallingEntities.add(entity);
    }

    public void updateWeather() {
        this.freefallingEntities.clear();
        super.updateWeather();
    }

    @SideOnly(value=Side.CLIENT)
    public void setSpinDeltaPerTick(float angle) {
        SkyProviderMarsSS skyProvider = (SkyProviderMarsSS)this.getSkyRenderer();
        if (skyProvider != null) {
            skyProvider.spinDeltaPerTick = angle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getSkyRotation() {
        SkyProviderMarsSS skyProvider = (SkyProviderMarsSS)this.getSkyRenderer();
        return skyProvider.spinAngle;
    }

    @SideOnly(value=Side.CLIENT)
    public void createSkyProvider() {
        this.setSkyRenderer((IRenderHandler)new SkyProviderMarsSS());
        this.setSpinDeltaPerTick(this.getSpinManager().getSpinRate());
        if (this.getCloudRenderer() == null) {
            this.setCloudRenderer((IRenderHandler)new CloudRenderer());
        }
    }

    public int getDungeonSpacing() {
        return 0;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasure.MOONCHEST;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }
}

