/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.integration.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGasGenerator;

public class ActionGasGeneratorRecipes {

    static class Remove
    implements IAction {
        private final ILiquidStack liquid;

        public Remove(ILiquidStack fluid) {
            this.liquid = fluid;
        }

        public void apply() {
            TileEntityGasGenerator.removeFuel(CraftTweakerMC.getLiquidStack((ILiquidStack)this.liquid).getFluid());
        }

        public String describe() {
            return "Removed Gas Generator recipe fluid for " + this.liquid;
        }
    }

    static class Add
    implements IAction {
        private final ILiquidStack liquid;
        private final int burn_time;
        private final float mod_energy;

        public Add(ILiquidStack liquid, int burn_time, float mod_energy) {
            this.liquid = liquid;
            this.burn_time = burn_time;
            this.mod_energy = mod_energy;
        }

        public void apply() {
            TileEntityGasGenerator.registerNewFuel(CraftTweakerMC.getLiquidStack((ILiquidStack)this.liquid).getFluid(), this.burn_time, this.mod_energy);
        }

        public String describe() {
            return "Added Gas Generator recipe fluid for " + this.liquid;
        }
    }
}

