/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine2.world.properties;

import asmodeuscore.core.utils.Utils;
import asmodeuscore.core.utils.worldengine2.world.biome.WE_Biome;
import asmodeuscore.core.utils.worldengine2.world.gen.noise.WE_IReliefGenerator;
import asmodeuscore.core.utils.worldengine2.world.gen.noise.WE_PerlinNoise;
import asmodeuscore.core.utils.worldengine2.world.gen.noise.WE_ValueNoise;
import asmodeuscore.core.utils.worldengine2.world.properties.WE_AbstactProperties;
import asmodeuscore.core.utils.worldengine2.world.properties.WE_IWorldProperties;
import java.util.ArrayList;

public class WE_WorldProperties
extends WE_AbstactProperties
implements WE_IWorldProperties {
    public ArrayList<WE_Biome> biomes;
    public ArrayList<GenReliefLayer> reliefLayers = new ArrayList();
    public ArrayList<GenBiomeMapLayer> bMapLayers = new ArrayList();
    public int defaultBiomeId = -1;
    public int lastBiome;

    public WE_WorldProperties() {
        this.biomes = new ArrayList();
    }

    public int addBiome(WE_Biome biome) {
        this.biomes.add(biome);
        this.lastBiome = this.biomes.size() - 1;
        return this.lastBiome;
    }

    public void setLastBiomeDefault() {
        this.defaultBiomeId = this.lastBiome;
    }

    public WE_Biome getLastBiome() {
        return this.biomes.get(this.lastBiome);
    }

    public void clearBiomes() {
        this.biomes.clear();
    }

    public void addReliefLayer(boolean isPerlin, int nOcts, double sx, double sz, byte inter, int iX, int iZ, byte iType, boolean iDoIfVoid) {
        this.reliefLayers.add(new GenReliefLayer(isPerlin, nOcts, sx, sz, inter, iX, iZ, iType, iDoIfVoid));
    }

    public void clearReliefLayers() {
        this.reliefLayers.clear();
    }

    public void addMapLayer(boolean isPerlin, double gPers, int nOcts, double sx, double sy, double sz, int sum, byte inter) {
        this.bMapLayers.add(new GenBiomeMapLayer(isPerlin, gPers, nOcts, sx, sy, sz, sum, inter));
    }

    public void clearMapLayers() {
        this.bMapLayers.clear();
    }

    @Override
    public WE_Biome getBiome(int i) {
        return this.biomes.get(i);
    }

    @Override
    public WE_Biome getDefaultBiome() {
        return this.defaultBiomeId >= 0 && this.defaultBiomeId < this.sizeofBiomes() ? this.getBiome(this.defaultBiomeId) : (WE_Biome)Utils.WE_Biome_2;
    }

    @Override
    public int sizeofBiomes() {
        return this.biomes.size();
    }

    @Override
    public WE_IWorldProperties.IGenReliefLayer getReliefLayer(int i) {
        return this.reliefLayers.get(i);
    }

    @Override
    public int sizeofReliefLayers() {
        return this.reliefLayers.size();
    }

    @Override
    public WE_IWorldProperties.IGenBiomeMapLayer getBiomeMapLayer(int i) {
        return this.bMapLayers.get(i);
    }

    @Override
    public int sizeofBiomeMapLayers() {
        return this.bMapLayers.size();
    }

    public class GenBiomeMapLayer
    implements WE_IWorldProperties.IGenBiomeMapLayer {
        public WE_IReliefGenerator biomeMapLayerNoise;

        public GenBiomeMapLayer(boolean isPerlin, double gPers, int nOcts, double sx, double sy, double sz, int sum, byte inter) {
            this.biomeMapLayerNoise = isPerlin ? new WE_PerlinNoise(0L, gPers, nOcts, sx, sy, sz, sum, inter) : new WE_ValueNoise(0L, gPers, nOcts, sx, sy, sz, sum, inter);
        }

        @Override
        public WE_IReliefGenerator getReliefGenerator() {
            return this.biomeMapLayerNoise;
        }
    }

    public class GenReliefLayer
    implements WE_IWorldProperties.IGenReliefLayer {
        public WE_IReliefGenerator reliefLayerNoise;
        public int[] interQuadSize;
        public byte interType;
        public boolean interDoIfVoid;

        public GenReliefLayer(boolean isPerlin, int nOcts, double sx, double sz, byte inter, int iX, int iZ, byte iType, boolean iDoIfVoid) {
            this.reliefLayerNoise = isPerlin ? new WE_PerlinNoise(0L, 0.0, nOcts, sx, 0.0, sz, 0, inter) : new WE_ValueNoise(0L, 0.0, nOcts, sx, 0.0, sz, 0, inter);
            this.interQuadSize = new int[2];
            this.interQuadSize[0] = iX;
            this.interQuadSize[1] = iZ;
            this.interType = iType;
            this.interDoIfVoid = iDoIfVoid;
        }

        @Override
        public WE_IReliefGenerator getReliefGenerator() {
            return this.reliefLayerNoise;
        }

        @Override
        public int[] getInterQuadSize() {
            return this.interQuadSize;
        }

        @Override
        public byte getInterType() {
            return this.interType;
        }

        @Override
        public boolean getInterDoIfVoid() {
            return this.interDoIfVoid;
        }
    }
}

