/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine2.world.gen.noise;

import asmodeuscore.core.utils.worldengine2.world.gen.noise.WE_IReliefGenerator;
import asmodeuscore.core.utils.worldengine2.world.gen.noise.WE_WhiteNoise;

public abstract class WE_NoiseTemplate
implements WE_IReliefGenerator {
    public double persistence;
    public double scaleX;
    public double scaleY;
    public double scaleZ;
    public int octaves;
    public int height;
    public byte iType;
    public WE_WhiteNoise rand;

    public WE_NoiseTemplate(long gSeed, double gPersistence, int numOfOctaves, double scl_x, double scl_y, double scl_z, int sum, byte interpolation) {
        this.persistence = gPersistence;
        this.octaves = numOfOctaves;
        this.scaleX = scl_x;
        this.scaleY = scl_y;
        this.scaleZ = scl_z;
        this.height = sum;
        this.iType = interpolation;
        this.rand = new WE_WhiteNoise(gSeed);
    }

    @Override
    public long getSeed() {
        return this.rand.seed;
    }

    @Override
    public void setSeed(long seed) {
        this.rand.seed = seed;
    }

    @Override
    public void setBiomeProperties(double pers, double sclY, int hght) {
        this.persistence = pers;
        this.scaleY = sclY;
        this.height = hght;
    }

    @Override
    public double genNoise2D(double x, double z) {
        double result = 0.0;
        double amplitudeMultiplier = 1.0;
        double nowX = x;
        double nowZ = z;
        for (int i = 0; i < this.octaves; ++i) {
            result += this.noiseOctave2D(nowX / this.scaleX, nowZ / this.scaleZ) * amplitudeMultiplier;
            amplitudeMultiplier *= this.persistence;
            nowX *= 2.0;
            nowZ *= 2.0;
        }
        return (double)this.height + result * this.scaleY;
    }

    public abstract double noiseOctave2D(double var1, double var3);
}

