/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils;

import com.mjr.planetprogression.api.research.ResearchHooksSP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class UtilsGC {
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBlockTexture(Block block) {
        return UtilsGC.getBlockTexture(block, "");
    }

    public static TextureAtlasSprite getBlockTexture(Block block, String addpath) {
        if (block == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = block.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b(spriteLocation.func_110624_b() + ":blocks/" + spriteLocation.func_110623_a() + addpath);
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static void drawFluid(int xPos, int yPos, int scale, FluidStack fluid) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = 0;
        int guiHeight = 0;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            UtilsGC.drawTexturedModalRect(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, UtilsGC.getFluidTexture(fluid.getFluid(), FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int getIntColor(int r, int g, int b, int a) {
        int A = a * 256 * 256 * 256;
        int R = r * 256 * 256;
        int G = g * 256;
        int B = b;
        int color = A + R + G + B;
        return color - 0x1000000;
    }

    public static float calculateCelestialAngle(long worldtime, float ticks, float daylenght) {
        int j = (int)((float)worldtime % daylenght);
        float f1 = ((float)j + ticks) / daylenght - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier, EntityPlayerMP playerBase) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!ConfigManagerCore.disableRocketsToOverworld) {
            temp.add(ConfigManagerCore.idDimensionOverworld);
        }
        for (Integer element : WorldUtil.registeredPlanets) {
            WorldProvider provider;
            if (element == ConfigManagerCore.idDimensionOverworld || (provider = WorldUtil.getProviderForDimensionServer((int)element)) == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        for (Integer element : WorldUtil.registeredSpaceStations.keySet()) {
            WorldProvider homeWorld;
            SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)element, null);
            if (ConfigManagerCore.spaceStationsRequirePermission && !data.getAllowedAll() && !data.getAllowedPlayers().contains(PlayerUtil.getName((EntityPlayer)playerBase)) && !ArrayUtils.contains((Object[])playerBase.field_71133_b.func_184103_al().func_152606_n(), (Object)playerBase.func_70005_c_())) continue;
            if (playerBase != null) {
                SpaceStationWorldData dataCurrent;
                int currentWorld = playerBase.field_71093_bK;
                if (currentWorld == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
                if (playerBase.field_70170_p.field_73011_w instanceof IOrbitDimension && (dataCurrent = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)playerBase.field_71093_bK, null)).getHomePlanet() == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
            }
            if ((homeWorld = WorldUtil.getProviderForDimensionServer((int)data.getHomePlanet())) == null) continue;
            if (homeWorld instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)homeWorld).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(int tier, EntityPlayerMP playerBase) {
        List<Integer> ids = UtilsGC.getPossibleDimensionsForSpaceshipTier(tier, playerBase);
        HashMap<String, Integer> map = new HashMap<String, Integer>(ids.size(), 1.0f);
        for (Integer id : ids) {
            CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID((int)id);
            if (id > 0 && celestialBody == null) {
                celestialBody = GalacticraftCore.satelliteSpaceStation;
                if (playerBase == null) continue;
                SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)id, null);
                map.put(celestialBody.getName() + "$" + data.getOwner() + "$" + data.getSpaceStationName() + "$" + id + "$" + data.getHomePlanet(), id);
                continue;
            }
            if (celestialBody == GalacticraftCore.planetOverworld) {
                map.put(celestialBody.getName(), id);
                continue;
            }
            WorldProvider provider = WorldUtil.getProviderForDimensionServer((int)id);
            if (celestialBody == null || provider == null || (!(provider instanceof IGalacticraftWorldProvider) || provider instanceof IOrbitDimension) && GCCoreUtil.getDimensionID((WorldProvider)provider) != 0) continue;
            map.put(celestialBody.getName(), GCCoreUtil.getDimensionID((WorldProvider)provider));
        }
        ArrayList cBodyList = new ArrayList();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (body.getReachable()) continue;
            map.put(body.getLocalizedName() + "*", body.getDimensionID());
        }
        WorldUtil.celestialMapCache.put(playerBase, map);
        return map;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensionsAgain(int tier, EntityPlayerMP playerBase) {
        HashMap map = (HashMap)WorldUtil.celestialMapCache.get(playerBase);
        if (map != null) {
            return map;
        }
        return UtilsGC.getArrayOfPossibleDimensions(tier, playerBase);
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="planetprogression")
    public static boolean hasUnlocks(EntityPlayerSP player, SolarSystem body) {
        return ResearchHooksSP.hasUnlockedBodiesInSystem((EntityPlayerSP)player, (SolarSystem)body);
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="planetprogression")
    public static boolean isReasearched(EntityPlayerSP player, CelestialBody body) {
        return ResearchHooksSP.hasUnlockedCelestialBody((EntityPlayerSP)player, (CelestialBody)body);
    }

    static {
        texMap = null;
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

