/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.dimension;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.IWeatherProvider;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.planets.GCPlanetDimensions;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import micdoodle8.mods.galacticraft.planets.venus.blocks.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.client.fx.ParticleAcidVapor;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.BiomeProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.ChunkProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomTreasureVenus;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderVenus
extends WorldProviderSpace
implements IGalacticraftWorldProvider,
ISolarLevel,
IWeatherProvider {
    private double solarMultiplier = -0.36;
    private float prevRainingStrength;
    private float rainingStrength;
    private boolean raining = false;
    private int rainTime = 100;
    private int rainChange = 100;
    private float targetRain = 0.0f;

    public Vector3 getFogColor() {
        float night = this.getStarBrightness(1.0f);
        float day = 1.0f - this.getStarBrightness(1.0f);
        float dayColR = 0.79607844f;
        float dayColG = 0.5764706f;
        float dayColB = 0.0f;
        float nightColR = 0.5137255f;
        float nightColG = 0.42352942f;
        float nightColB = 0.18039216f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    public Vector3 getSkyColor() {
        float night = this.getStarBrightness(1.0f);
        float day = 1.0f - this.getStarBrightness(1.0f);
        float dayColR = 1.0f;
        float dayColG = 0.8117647f;
        float dayColB = 0.31764707f;
        float nightColR = 0.4627451f;
        float nightColG = 0.34901962f;
        float nightColB = 0.08235294f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 720000L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderVenus.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)VenusModule.planetVenus);
        return BiomeProviderVenus.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.75f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 76;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public float getGravity() {
        return 0.0375f;
    }

    public double getFuelUsageMultiplier() {
        return 0.9;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 3;
    }

    public float getFallDamageModifier() {
        return 0.38f;
    }

    public CelestialBody getCelestialBody() {
        return VenusModule.planetVenus;
    }

    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            this.solarMultiplier = s * s * s;
        }
        return this.solarMultiplier;
    }

    public boolean shouldDisablePrecipitation() {
        return false;
    }

    public DimensionType func_186058_p() {
        return GCPlanetDimensions.VENUS;
    }

    public int getDungeonSpacing() {
        return 704;
    }

    public float getArrowGravity() {
        return 0.0275f;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasureVenus.VENUSCHEST;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(VenusBlocks.venusBlock);
        return list;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Particle getParticle(WorldClient world, double x, double y, double z) {
        return new ParticleAcidVapor((World)world, x, y, z, 0.0, 0.0, 0.0, 0.95f);
    }

    protected void updateWeatherOverride() {
        if (!this.field_76579_a.field_72995_K) {
            float strength;
            if (--this.rainTime <= 0) {
                this.raining = !this.raining;
                this.rainTime = this.raining ? this.field_76579_a.field_73012_v.nextInt(3600) + 1000 : this.field_76579_a.field_73012_v.nextInt(2000) + 1000;
            }
            if (--this.rainChange <= 0) {
                this.targetRain = 0.15f + this.field_76579_a.field_73012_v.nextFloat() * 0.45f;
                this.rainChange = this.field_76579_a.field_73012_v.nextInt(200) + 100;
            }
            this.field_76579_a.field_73003_n = strength = this.field_76579_a.field_73004_o;
            if (this.raining && strength < this.targetRain) {
                strength += 0.004f;
            } else if (!this.raining || strength > this.targetRain) {
                strength -= 0.004f;
            }
            this.field_76579_a.field_73004_o = MathHelper.func_76131_a((float)strength, (float)0.0f, (float)0.6f);
        }
    }

    public void weatherSounds(int j, Minecraft mc, World world, BlockPos blockpos, double xx, double yy, double zz, Random random) {
        if ((int)yy >= blockpos.func_177956_o() + 1 && world.func_175725_q(blockpos).func_177956_o() > blockpos.func_177956_o()) {
            mc.field_71441_e.func_184134_a(xx, yy, zz, SoundEvents.field_187659_cY, SoundCategory.WEATHER, 0.025f, 0.6f + random.nextFloat() * 0.2f, false);
        } else {
            mc.field_71441_e.func_184134_a(xx, yy, zz, SoundEvents.field_187659_cY, SoundCategory.WEATHER, 0.04f, 0.8f + random.nextFloat() * 0.06f + random.nextFloat() * 0.06f, false);
        }
    }

    public int getSoundInterval(float rainStrength) {
        int result = 80 - (int)(rainStrength * 88.0f);
        return result > 0 ? result : 0;
    }
}

