/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class ColorUtil {
    static Vector3 red = new Vector3(255.0, 0.0, 0.0);
    static Vector3 orange = new Vector3(255.0, 160.0, 0.0);
    static Vector3 yellow = new Vector3(255.0, 255.0, 0.0);
    static Vector3 green = new Vector3(0.0, 255.0, 0.0);
    static Vector3 cyan = new Vector3(0.0, 255.0, 255.0);
    static Vector3 blue = new Vector3(0.0, 0.0, 255.0);
    static Vector3 magenta = new Vector3(255.0, 0.0, 255.0);
    static Vector3 white = new Vector3(255.0, 255.0, 255.0);
    static Vector3 black = new Vector3(0.0, 0.0, 0.0);
    static Vector3 mud = new Vector3(94.0, 81.0, 74.0);
    static double[] colorwheelAngles = new double[]{-110.0, -30.0, 0.0, 60.0, 120.0, 180.0, 215.0, 250.0, 330.0, 360.0, 420.0, 480.0};
    static Vector3[] colorwheelColors = new Vector3[]{blue, magenta, red, orange, yellow, green, cyan, blue, magenta, red, orange, yellow};

    private static Vector3 hue_to_rgb(double deg) {
        deg %= 360.0;
        double previous_angle = colorwheelAngles[1];
        for (int i = 2; i < colorwheelAngles.length - 2; ++i) {
            Double angle = colorwheelAngles[i];
            if (deg <= angle) {
                return ColorUtil.interpolateInArray(colorwheelColors, i, (angle - deg) / (angle - previous_angle));
            }
            previous_angle = angle;
        }
        return null;
    }

    private static double rgb_to_hue(Vector3 input) {
        double hue;
        double separation2;
        double maxCol = Math.max(Math.max(input.x, input.y), input.z);
        if (maxCol <= 0.0) {
            return 0.0;
        }
        Vector3 rgb = input.scale(255.0 / maxCol);
        double mindist = 1024.0;
        int mini = 0;
        for (int i = 2; i < colorwheelAngles.length - 2; ++i) {
            Vector3 color = colorwheelColors[i];
            double separation = color.distance(rgb);
            if (!(separation < mindist)) continue;
            mindist = separation;
            mini = i;
        }
        double separation1 = colorwheelColors[mini - 1].distance(rgb);
        if (separation1 < (separation2 = colorwheelColors[mini + 1].distance(rgb))) {
            double separationtot = colorwheelColors[mini - 1].distance(colorwheelColors[mini]);
            hue = ColorUtil.interpolateInArray(colorwheelAngles, mini, mindist / separationtot);
            if (hue < 0.0) {
                hue += 360.0;
            }
        } else {
            double separationtot = colorwheelColors[mini + 1].distance(colorwheelColors[mini]);
            hue = ColorUtil.interpolateInArray(colorwheelAngles, mini + 1, separation2 / separationtot);
            if (hue > 360.0) {
                hue -= 360.0;
            }
        }
        return hue;
    }

    private static double cubicInterpolate(double y0, double y1, double y2, double y3, double mu) {
        double mu2 = mu * mu;
        double a3 = y3 - y2 - y0 + y1;
        double a2 = y0 - y1 - a3;
        double a1 = y2 - y0;
        double a0 = y1;
        return a3 * mu * mu2 + a2 * mu2 + a1 * mu + a0;
    }

    private static Vector3 interpolateInArray(Vector3[] array, int i, double mu) {
        Vector3 point0 = array[i + 1];
        Vector3 point1 = array[i];
        Vector3 point2 = array[i - 1];
        Vector3 point3 = array[i - 2];
        double x = ColorUtil.cubicInterpolate(point0.x, point1.x, point2.x, point3.x, mu);
        double y = ColorUtil.cubicInterpolate(point0.y, point1.y, point2.y, point3.y, mu);
        double z = ColorUtil.cubicInterpolate(point0.z, point1.z, point2.z, point3.z, mu);
        return new Vector3(x, y, z);
    }

    private static double interpolateInArray(double[] array, int i, double mu) {
        return ColorUtil.cubicInterpolate(array[i + 1], array[i], array[i - 1], array[i - 2], mu);
    }

    public static Vector3 addColorsRealistically(Vector3 color1, Vector3 color2) {
        double hueresult;
        double hue2;
        double hue1 = ColorUtil.rgb_to_hue(color1);
        if (hue1 - (hue2 = ColorUtil.rgb_to_hue(color2)) > 180.0) {
            hue2 += 360.0;
        }
        if (hue2 - hue1 > 180.0) {
            hue1 += 360.0;
        }
        if ((hueresult = (hue1 + hue2) / 2.0) > 360.0) {
            hueresult -= 360.0;
        }
        return ColorUtil.hue_to_rgb(hueresult).scale(0.00392156862745098);
    }

    public static int addColorsRealistically(int color1, int color2) {
        Vector3 result = ColorUtil.addColorsRealistically(ColorUtil.toVec3(color1), ColorUtil.toVec3(color2));
        return ColorUtil.fromVec3(result);
    }

    public static int addColorsBasic(int color1, int color2) {
        int g = color1 >> 8;
        int r = g >> 8;
        g &= 0xFF;
        int b = color1 & 0xFF;
        int gg = color2 >> 8;
        int rr = gg >> 8;
        int bb = color2 & 0xFF;
        r = (r + rr) / 2;
        g = (g + (gg &= 0xFF)) / 2;
        b = (b + bb) / 2;
        return (r <<= 16) | (g <<= 8) | b;
    }

    public static Vector3 toVec3(int col) {
        int gg = col >> 8;
        int rr = gg >> 8;
        int bb = col & 0xFF;
        return new Vector3((float)rr / 255.0f, (float)(gg &= 0xFF) / 255.0f, (float)bb / 255.0f);
    }

    public static int fromVec3(Vector3 result) {
        int r = (int)(result.x * 255.0 + 0.499);
        int g = (int)(result.y * 255.0 + 0.499);
        int b = (int)(result.z * 255.0 + 0.499);
        return (r <<= 16) | (g <<= 8) | b;
    }

    public static int to32BitColor(int a, int r, int g, int b) {
        return (a <<= 24) | (r <<= 16) | (g <<= 8) | b;
    }

    public static int to32BitColorB(byte r, byte g, byte b) {
        int rr = (r & 0xFF) << 16;
        int gg = (g & 0xFF) << 8;
        return rr | gg | b & 0xFF;
    }

    public static int lighten(int col, float factor) {
        int gg = col >> 8;
        int rr = gg >> 8;
        gg &= 0xFF;
        int bb = col & 0xFF;
        rr = (int)((float)rr * (1.0f + factor));
        gg = (int)((float)gg * (1.0f + factor));
        bb = (int)((float)bb * (1.0f + factor));
        if (rr > 255) {
            rr = 255;
        }
        if (gg > 255) {
            gg = 255;
        }
        if (bb > 255) {
            bb = 255;
        }
        return rr << 16 | gg << 8 | bb;
    }

    public static int lightenFully(int col, int intensity) {
        if (intensity == 0) {
            return 0;
        }
        int gg = col >> 8;
        int rr = gg >> 8;
        gg &= 0xFF;
        int bb = col & 0xFF;
        rr = 255 - rr;
        gg = 255 - gg;
        bb = 255 - bb;
        double greyInvert = Math.min(rr, Math.min(gg, bb));
        double delta = Math.max(rr, Math.max(gg, bb));
        delta = (delta - greyInvert) / delta;
        if (greyInvert >= (double)intensity) {
            return col;
        }
        double factor = ((double)intensity - greyInvert) / (double)intensity / Math.pow(delta, 0.6);
        rr -= 24;
        gg -= 24;
        bb -= 24;
        rr = (int)((double)rr * factor);
        gg = (int)((double)gg * factor);
        bb = (int)((double)bb * factor);
        if (rr > 255) {
            rr = 255;
        }
        if (gg > 255) {
            gg = 255;
        }
        if (bb > 255) {
            bb = 255;
        }
        rr = 255 - rr;
        gg = 255 - gg;
        bb = 255 - bb;
        if (rr > 255) {
            rr = 255;
        }
        if (gg > 255) {
            gg = 255;
        }
        if (bb > 255) {
            bb = 255;
        }
        return rr << 16 | gg << 8 | bb;
    }

    public static int toGreyscale(int col) {
        int gg = col >> 8;
        int grey = gg >> 8;
        grey += gg & 0xFF;
        grey += col & 0xFF;
        return (grey /= 3) << 16 | grey << 8 | grey & 0xFF;
    }

    public static void sendUpdatedColorsToPlayer(GCPlayerStats stats) {
        int dimID = ((EntityPlayerMP)stats.getPlayer().get()).field_71093_bK;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RECOLOR_ALL_GLASS, dimID, new Object[]{stats.getGlassColor1(), stats.getGlassColor2(), stats.getGlassColor3()}), (EntityPlayerMP)stats.getPlayer().get());
    }

    public static void updateColorsForArea(int dimID, BlockPos pos, int range, int color1, int color2, int color3) {
        GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_RECOLOR_ALL_GLASS, dimID, new Object[]{color1, color2, color3}), new NetworkRegistry.TargetPoint(dimID, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)range));
    }

    public static void setGLColor(int col) {
        int gg = col >> 8;
        int rr = gg >> 8;
        int bb = col & 0xFF;
        GlStateManager.func_179131_c((float)((float)rr / 255.0f), (float)((float)(gg &= 0xFF) / 255.0f), (float)((float)bb / 255.0f), (float)1.0f);
    }
}

