/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityDeconstructor
extends TileBaseElectricBlock
implements IInventoryDefaults,
ISidedInventory,
IMachineSides {
    public static final float SALVAGE_CHANCE = 0.75f;
    public static final int PROCESS_TIME_REQUIRED_BASE = 250;
    public int processTimeRequired = 250;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = ItemStack.field_190927_a;
    private long ticks;
    public static List<ItemStack> salvageable = new LinkedList<ItemStack>();
    public static List<INasaWorkbenchRecipe> knownRecipes = new LinkedList<INasaWorkbenchRecipe>();
    private int recursiveCount;
    private IMachineSides.MachineSidePack[] machineSides;

    private static void initialiseItemList() {
        if (GalacticraftCore.isPlanetsLoaded) {
            TileEntityDeconstructor.addSalvage(new ItemStack(AsteroidItems.basicItem, 1, 5));
            TileEntityDeconstructor.addSalvage(new ItemStack(AsteroidItems.basicItem, 1, 6));
            TileEntityDeconstructor.addSalvage(new ItemStack(AsteroidItems.basicItem, 1, 0));
            TileEntityDeconstructor.addSalvage(new ItemStack(MarsItems.marsItemBasic, 1, 3));
            TileEntityDeconstructor.addSalvage(new ItemStack(MarsItems.marsItemBasic, 1, 5));
            TileEntityDeconstructor.addSalvage(new ItemStack(MarsItems.marsItemBasic, 1, 2));
        }
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.flagPole));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.heavyPlatingTier1));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.itemBasicMoon, 1, 1));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.itemBasicMoon, 1, 0));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 9));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 10));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 6));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 7));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 8));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 11));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 3));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 4));
        TileEntityDeconstructor.addSalvage(new ItemStack(GCItems.basicItem, 1, 5));
        TileEntityDeconstructor.addSalvage(new ItemStack(Items.field_151042_j));
        TileEntityDeconstructor.addSalvage(new ItemStack(Items.field_151043_k));
        TileEntityDeconstructor.addSalvage(new ItemStack(Items.field_151074_bl));
        TileEntityDeconstructor.addSalvage(new ItemStack(Items.field_151045_i));
    }

    public static void initialiseRecipeList() {
        knownRecipes.addAll(GalacticraftRegistry.getRocketT1Recipes());
        knownRecipes.addAll(GalacticraftRegistry.getBuggyBenchRecipes());
    }

    public static void initialiseRecipeListPlanets() {
        knownRecipes.addAll(GalacticraftRegistry.getRocketT2Recipes());
        knownRecipes.addAll(GalacticraftRegistry.getCargoRocketRecipes());
        knownRecipes.addAll(GalacticraftRegistry.getRocketT3Recipes());
        knownRecipes.addAll(GalacticraftRegistry.getAstroMinerRecipes());
    }

    public TileEntityDeconstructor() {
        super("tile.machine2.10.name");
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.setTierGC(2);
        this.inventory = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
    }

    public static void addSalvage(ItemStack itemStack) {
        for (ItemStack inList : salvageable) {
            if (!ItemStack.func_179545_c((ItemStack)inList, (ItemStack)itemStack)) continue;
            return;
        }
        salvageable.add(itemStack.func_77946_l());
    }

    public static boolean isSalvage(ItemStack stack) {
        for (ItemStack inList : salvageable) {
            if (!ItemStack.func_179545_c((ItemStack)inList, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canDeconstruct()) {
                    ++this.processTicks;
                    if (this.processTicks * 5 % this.processTimeRequired == 5) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), GCSounds.deconstructor, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.04f + 0.38f);
                    }
                    if (this.processTicks >= this.processTimeRequired) {
                        this.processTicks = 0;
                        this.deconstruct();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    private boolean canDeconstruct() {
        return !((ItemStack)this.getInventory().get(1)).func_190926_b();
    }

    public void deconstruct() {
        LinkedList<ItemStack> ingredients = new LinkedList<ItemStack>();
        ingredients.add(new ItemStack(((ItemStack)this.getInventory().get(1)).func_77973_b(), 1, ((ItemStack)this.getInventory().get(1)).func_77952_i()));
        this.recursiveCount = 0;
        List<ItemStack> salvaged = this.getSalvageable(ingredients, null);
        salvaged = this.squashList(salvaged);
        salvaged = this.randomChanceList(salvaged);
        if (salvaged != null) {
            for (ItemStack output : salvaged) {
                this.addToOutputMatrix(output);
            }
        }
        this.func_70298_a(1, 1);
    }

    private List<ItemStack> getSalvageable(List<ItemStack> ingredients, ItemStack done) {
        if (ingredients == null || ingredients.isEmpty()) {
            return null;
        }
        if (this.recursiveCount++ > 10) {
            return null;
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack stack : ingredients) {
            List<ItemStack> recursive;
            if (TileEntityDeconstructor.isSalvage(stack)) {
                ret.add(stack);
                continue;
            }
            GCLog.debug("Trying to " + this.recursiveCount + " break down " + stack.toString());
            List<ItemStack> ingredients2 = this.getIngredients(stack);
            if (ingredients2 == null) continue;
            if (done != null) {
                Iterator<ItemStack> it = ingredients2.iterator();
                while (it.hasNext()) {
                    if (!ItemStack.func_77989_b((ItemStack)it.next(), (ItemStack)done)) continue;
                    it.remove();
                }
            }
            if ((recursive = this.getSalvageable(ingredients2, stack)) == null || recursive.isEmpty()) continue;
            ret.addAll(recursive);
        }
        --this.recursiveCount;
        return ret;
    }

    private List<ItemStack> squashList(List<ItemStack> ingredients) {
        if (ingredients == null || ingredients.isEmpty()) {
            return null;
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack stack : ingredients) {
            boolean matched = false;
            for (ItemStack stack1 : ret) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stack1)) continue;
                matched = true;
                stack1.func_190917_f(stack.func_190916_E());
                break;
            }
            if (matched) continue;
            ret.add(stack);
        }
        return ret;
    }

    private List<ItemStack> randomChanceList(List<ItemStack> ingredients) {
        if (ingredients == null || ingredients.isEmpty()) {
            return null;
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack stack : ingredients) {
            int count = stack.func_190916_E();
            int result = 0;
            for (int i = 0; i < count; ++i) {
                if (!(this.field_145850_b.field_73012_v.nextFloat() < 0.75f)) continue;
                ++result;
            }
            if (result <= 0) continue;
            stack.func_190920_e(result);
            ret.add(stack);
        }
        return ret;
    }

    private List<ItemStack> getIngredients(ItemStack stack) {
        ItemStack test;
        for (INasaWorkbenchRecipe recipe : knownRecipes) {
            test = recipe.getRecipeOutput();
            if (!ItemStack.func_179545_c((ItemStack)test, (ItemStack)stack) || test.func_190916_E() != 1) continue;
            return this.toItemStackList(recipe.getRecipeInput().values());
        }
        for (INasaWorkbenchRecipe recipe : CraftingManager.field_193380_a) {
            test = recipe.func_77571_b();
            if (!ItemStack.func_179545_c((ItemStack)test, (ItemStack)stack) || test.func_190916_E() != 1) continue;
            if (recipe instanceof ShapedRecipes) {
                return this.expandRecipeInputs((List<?>)((ShapedRecipes)recipe).field_77574_d);
            }
            if (recipe instanceof ShapelessRecipes) {
                return this.expandRecipeInputs((List<?>)((ShapelessRecipes)recipe).field_77579_b);
            }
            if (recipe instanceof ShapedOreRecipe) {
                return this.expandRecipeInputs((List<?>)((ShapedOreRecipe)recipe).func_192400_c());
            }
            if (!(recipe instanceof ShapelessOreRecipe)) continue;
            return this.expandRecipeInputs((List<?>)((ShapelessOreRecipe)recipe).func_192400_c());
        }
        return null;
    }

    private List<ItemStack> expandRecipeInputs(List<?> inputs) {
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (Object input : inputs) {
            ItemStack toAdd = this.parseRecipeInput(input);
            if (toAdd == null || toAdd.func_190926_b()) continue;
            ret.add(toAdd);
        }
        return ret;
    }

    private ItemStack parseRecipeInput(Object input) {
        block8: {
            block7: {
                if (!(input instanceof Ingredient)) break block7;
                for (ItemStack obj : ((Ingredient)input).func_193365_a()) {
                    ItemStack ret = this.parseRecipeInput(obj);
                    if (ret == null) continue;
                    return ret;
                }
                break block8;
            }
            if (input instanceof ItemStack) {
                ItemStack stack = (ItemStack)input;
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    return new ItemStack(stack.func_77973_b(), stack.func_190916_E(), 0);
                }
                return stack.func_77946_l();
            }
            if (input instanceof String) {
                NonNullList stacks = OreDictionary.getOres((String)((String)input));
                if (stacks.isEmpty()) {
                    return null;
                }
                for (ItemStack stack : stacks) {
                    if (!TileEntityDeconstructor.isSalvage(stack)) continue;
                    return stack.func_77946_l();
                }
                return stacks.get(0) == null ? null : ((ItemStack)stacks.get(0)).func_77946_l();
            }
            if (!(input instanceof Iterable)) break block8;
            for (Object obj : (Iterable)input) {
                ItemStack ret = this.parseRecipeInput(obj);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private List<ItemStack> toItemStackList(Collection<ItemStack> inputs) {
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        for (ItemStack o : inputs) {
            if (o == null || o.func_190926_b()) continue;
            ret.add(o.func_77946_l());
        }
        return ret;
    }

    private void addToOutputMatrix(ItemStack stack) {
        for (int i = 2; i < 11; ++i) {
            if (((ItemStack)this.getInventory().get(i)).func_190926_b()) {
                this.getInventory().set(i, (Object)stack);
                return;
            }
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((ItemStack)this.getInventory().get(i)))) continue;
            int size = ((ItemStack)this.getInventory().get(i)).func_190916_E();
            if (size + stack.func_190916_E() < this.func_70297_j_()) {
                ((ItemStack)this.getInventory().get(i)).func_190917_f(stack.func_190916_E());
                return;
            }
            ((ItemStack)this.getInventory().get(i)).func_190920_e(this.func_70297_j_());
            stack.func_190918_g(this.func_70297_j_() - size);
        }
        GCCoreUtil.spawnItem(this.field_145850_b, this.func_174877_v(), stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.readMachineSidesFromNBT(par1NBTTagCompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.addMachineSidesToNBT(nbt);
        return nbt;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && !itemStack.func_190926_b() && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
        }
        return slotID == 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        }
        return new int[]{1};
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID >= 2;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    @Override
    public EnumFacing getFront() {
        return BlockMachineBase.getFront(this.field_145850_b.func_180495_p(this.func_174877_v()));
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    @Override
    public synchronized IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachine2.MACHINESIDES_RENDERTYPE;
    }

    static {
        TileEntityDeconstructor.initialiseItemList();
    }
}

