/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import api.player.server.ServerPlayerAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCBodies;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.advancement.GCTriggers;
import micdoodle8.mods.galacticraft.core.blocks.BlockGrating;
import micdoodle8.mods.galacticraft.core.client.gui.GuiHandler;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenBasic;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenCelestial;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenText;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.command.CommandGCEnergyUnits;
import micdoodle8.mods.galacticraft.core.command.CommandGCHelp;
import micdoodle8.mods.galacticraft.core.command.CommandGCHouston;
import micdoodle8.mods.galacticraft.core.command.CommandGCInv;
import micdoodle8.mods.galacticraft.core.command.CommandGCKit;
import micdoodle8.mods.galacticraft.core.command.CommandJoinSpaceRace;
import micdoodle8.mods.galacticraft.core.command.CommandKeepDim;
import micdoodle8.mods.galacticraft.core.command.CommandPlanetTeleport;
import micdoodle8.mods.galacticraft.core.command.CommandRotatePlayer;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationAddOwner;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationChangeOwner;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationRemoveOwner;
import micdoodle8.mods.galacticraft.core.dimension.GCDimensions;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.grid.ChunkPowerHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.TileCableIC2Sealed;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityFlag;
import micdoodle8.mods.galacticraft.core.entities.EntityHangingSchematic;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.entities.EntityParachest;
import micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.EntityTier1Rocket;
import micdoodle8.mods.galacticraft.core.entities.player.GCCapabilities;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerBaseMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.event.LootHandlerGC;
import micdoodle8.mods.galacticraft.core.items.ItemSchematic;
import micdoodle8.mods.galacticraft.core.network.ConnectionEvents;
import micdoodle8.mods.galacticraft.core.network.ConnectionPacket;
import micdoodle8.mods.galacticraft.core.network.GalacticraftChannelHandler;
import micdoodle8.mods.galacticraft.core.proxy.CommonProxyCore;
import micdoodle8.mods.galacticraft.core.recipe.RecipeManagerGC;
import micdoodle8.mods.galacticraft.core.schematic.SchematicAdd;
import micdoodle8.mods.galacticraft.core.schematic.SchematicMoonBuggy;
import micdoodle8.mods.galacticraft.core.schematic.SchematicRocketT1;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWireSwitch;
import micdoodle8.mods.galacticraft.core.tile.TileEntityArclamp;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFueler;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFuelerSingle;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoUnloader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCircuitFabricator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCrafting;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDeconstructor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEmergencyBox;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFallenMeteor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPadSingle;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNasaWorkbench;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNull;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDecompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPainter;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPanelLight;
import micdoodle8.mods.galacticraft.core.tile.TileEntityParaChest;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPlatform;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPlayerDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySolar;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySpaceStationBase;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.tile.TileEntityThruster;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.ThreadRequirementMissing;
import micdoodle8.mods.galacticraft.core.util.ThreadVersionCheck;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.world.gen.OreGenOtherMods;
import micdoodle8.mods.galacticraft.core.world.gen.OverworldGenerator;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.RecipeManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.recipe.RecipeManagerMars;
import micdoodle8.mods.galacticraft.planets.venus.recipe.RecipeManagerVenus;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod(modid="galacticraftcore", useMetadata=true, acceptedMinecraftVersions="[1.12,1.13)", guiFactory="micdoodle8.mods.galacticraft.core.client.gui.screen.ConfigGuiFactoryCore", version="4.0.2.280")
public class GalacticraftCore {
    public static final String NAME = "Galacticraft Core";
    public static final String GUIFACTORY = "micdoodle8.mods.galacticraft.core.client.gui.screen.ConfigGuiFactoryCore";
    private File GCCoreSource;
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore", serverSide="micdoodle8.mods.galacticraft.core.proxy.CommonProxyCore")
    public static CommonProxyCore proxy;
    @Mod.Instance(value="galacticraftcore")
    public static GalacticraftCore instance;
    public static boolean isPlanetsLoaded;
    public static boolean isHeightConflictingModInstalled;
    public static GalacticraftChannelHandler packetPipeline;
    public static GCPlayerHandler handler;
    public static CreativeTabGC galacticraftBlocksTab;
    public static CreativeTabGC galacticraftItemsTab;
    public static SolarSystem solarSystemSol;
    public static Planet planetMercury;
    public static Planet planetVenus;
    public static Planet planetMars;
    public static Planet planetOverworld;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Moon moonMoon;
    public static Satellite satelliteSpaceStation;
    public static LinkedList<ItemStack> itemList;
    public static LinkedList<Item> itemListTrue;
    public static LinkedList<Block> blocksList;
    public static LinkedList<BiomeGenBaseGC> biomesList;
    public static ImageWriter jpgWriter;
    public static ImageWriteParam writeParam;
    public static boolean enableJPEG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.GCCoreSource = event.getSourceFile();
        GCCapabilities.register();
        isPlanetsLoaded = Loader.isModLoaded((String)"galacticraftplanets");
        GCCoreUtil.nextID = 0;
        if (CompatibilityManager.isSmartMovingLoaded || CompatibilityManager.isWitcheryLoaded) {
            isHeightConflictingModInstalled = true;
        }
        GCBodies.instance().preInit();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerGC());
        handler = new GCPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        proxy.preInit(event);
        ConnectionPacket.bus = NetworkRegistry.INSTANCE.newEventDrivenChannel("galacticraft");
        ConnectionPacket.bus.register((Object)new ConnectionPacket());
        ConfigManagerCore.initialize(new File(event.getModConfigurationDirectory(), "Galacticraft/core.conf"));
        EnergyConfigHandler.setDefaultValues(new File(event.getModConfigurationDirectory(), "Galacticraft/power.conf"));
        ChunkLoadingCallback.loadConfig(new File(event.getModConfigurationDirectory(), "Galacticraft/chunkloading.conf"));
        galacticraftBlocksTab = new CreativeTabGC(CreativeTabs.getNextID(), "galacticraft_blocks", null, null);
        galacticraftItemsTab = new CreativeTabGC(CreativeTabs.getNextID(), "galacticraft_items", null, null);
        GCFluids.registerOilandFuel();
        if (CompatibilityManager.PlayerAPILoaded) {
            ServerPlayerAPI.register((String)"galacticraftcore", GCPlayerBaseMP.class);
        }
        GCBlocks.initBlocks();
        GCItems.initItems();
        GCFluids.registerFluids();
        GCBodies.instance().setBiomes();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        galacticraftBlocksTab.setItemForTab(new ItemStack(Item.func_150898_a((Block)GCBlocks.machineBase2)));
        galacticraftItemsTab.setItemForTab(new ItemStack(GCItems.rocketTier1));
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GCBlocks.finalizeSort();
            GCItems.finalizeSort();
        }
        proxy.init(event);
        packetPipeline = GalacticraftChannelHandler.init();
        GCBodies.instance().init();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
        MinecraftForge.EVENT_BUS.register((Object)new ConnectionEvents());
        SchematicRegistry.registerSchematicRecipe(new SchematicRocketT1());
        SchematicRegistry.registerSchematicRecipe(new SchematicMoonBuggy());
        SchematicRegistry.registerSchematicRecipe(new SchematicAdd());
        ChunkPowerHandler.initiate();
        EnergyConfigHandler.initGas();
        LootHandlerGC.registerAll();
        this.registerCreatures();
        this.registerOtherEntities();
        this.registerTileEntities();
        GCBodies.instance().registerBodies();
        if (ConfigManagerCore.enableCopperOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 5, 24, 0, 75, 7), (int)4);
        }
        if (ConfigManagerCore.enableTinOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 6, 22, 0, 60, 7), (int)4);
        }
        if (ConfigManagerCore.enableAluminumOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 7, 18, 0, 45, 7), (int)4);
        }
        if (ConfigManagerCore.enableSiliconOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 8, 3, 0, 25, 7), (int)4);
        }
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"http://www.patreon.com/micdoodle8");
        GalacticraftCore.registerCoreGameScreens();
        GCFluids.registerLegacyFluids();
        GCFluids.registerDispenserBehaviours();
        if (CompatibilityManager.isBCraftEnergyLoaded()) {
            GCFluids.registerBCFuel();
        }
        GalacticraftRegistry.registerGear(0, EnumExtendedInventorySlot.MASK, GCItems.oxMask);
        GalacticraftRegistry.registerGear(1, EnumExtendedInventorySlot.GEAR, GCItems.oxygenGear);
        GalacticraftRegistry.registerGear(2, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxTankLight);
        GalacticraftRegistry.registerGear(2, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxTankLight);
        GalacticraftRegistry.registerGear(3, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxTankMedium);
        GalacticraftRegistry.registerGear(3, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxTankMedium);
        GalacticraftRegistry.registerGear(4, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxTankHeavy);
        GalacticraftRegistry.registerGear(4, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxTankHeavy);
        GalacticraftRegistry.registerGear(5, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxygenCanisterInfinite);
        GalacticraftRegistry.registerGear(5, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxygenCanisterInfinite);
        GalacticraftRegistry.registerGear(14, EnumExtendedInventorySlot.PARACHUTE, GCItems.parachute);
        GalacticraftRegistry.registerGear(15, EnumExtendedInventorySlot.FREQUENCY_MODULE, new ItemStack(GCItems.basicItem, 1, 19));
        proxy.registerFluidTexture(GCFluids.fluidOil, new ResourceLocation("galacticraftcore", "textures/misc/underoil.png"));
        proxy.registerFluidTexture(GCFluids.fluidFuel, new ResourceLocation("galacticraftcore", "textures/misc/underfuel.png"));
        PermissionAPI.registerNode((String)"galacticraft.station.create", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allows players to create space stations");
        GCTriggers.registerTriggers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GCBodies.instance().postInit();
        MinecraftForge.EVENT_BUS.register((Object)new OreGenOtherMods());
        proxy.postInit(event);
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (body.shouldAutoRegister()) {
                int id = body.getDimensionID();
                DimensionType type = GalacticraftRegistry.registerDimension(body.getUnlocalizedName(), body.getDimensionSuffix(), body.getDimensionID(), body.getWorldProvider(), body.getForceStaticLoad() || id < 0);
                if (type != null) {
                    body.initialiseMobSpawns();
                } else {
                    body.setUnreachable();
                    GCLog.error("Tried to register dimension for body: " + body.getUnlocalizedName() + " hit conflict with ID " + body.getDimensionID(), new Object[0]);
                }
            }
            if (body.getSurfaceBlocks() == null) continue;
            TransformerHooks.spawnListAE2_GC.addAll(body.getSurfaceBlocks());
        }
        GCDimensions.MOON = WorldUtil.getDimensionTypeById(ConfigManagerCore.idDimensionMoon);
        CompatibilityManager.checkForCompatibleMods();
        RecipeManagerGC.loadCompatibilityRecipes();
        TileEntityDeconstructor.initialiseRecipeList();
        ItemSchematic.registerSchematicItems();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerServer());
        GalaxyRegistry.refreshGalaxies();
        GalacticraftRegistry.registerScreen(new GameScreenText());
        try {
            jpgWriter = ImageIO.getImageWritersBySuffix("jpg").next();
            writeParam = jpgWriter.getDefaultWriteParam();
            writeParam.setCompressionMode(2);
            writeParam.setCompressionQuality(1.0f);
            enableJPEG = true;
        }
        catch (UnsatisfiedLinkError e) {
            GCLog.error("Error initialising JPEG compressor - this is likely caused by OpenJDK - see https://wiki.micdoodle8.com/wiki/Compatibility#For_clients_running_OpenJDK", new Object[0]);
            e.printStackTrace();
        }
        if (event.getSide() == Side.SERVER) {
            this.loadLanguageCore("en_US");
        }
    }

    public void loadLanguageCore(String lang) {
        GCCoreUtil.loadLanguage(lang, "galacticraftcore", this.GCCoreSource);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        TickHandlerServer.restart();
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        if (ThreadRequirementMissing.INSTANCE == null) {
            ThreadRequirementMissing.beginCheck(GCCoreUtil.getEffectiveSide());
        }
        ThreadVersionCheck.startCheck();
        BlockVec3.chunkCacheDim = Integer.MAX_VALUE;
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        GCCoreUtil.notifyStarted(event.getServer());
        File worldFolder = DimensionManager.getCurrentSaveRootDirectory();
        event.registerServerCommand((ICommand)new CommandSpaceStationAddOwner());
        event.registerServerCommand((ICommand)new CommandSpaceStationChangeOwner());
        event.registerServerCommand((ICommand)new CommandSpaceStationRemoveOwner());
        event.registerServerCommand((ICommand)new CommandPlanetTeleport());
        event.registerServerCommand((ICommand)new CommandKeepDim());
        event.registerServerCommand((ICommand)new CommandGCInv());
        event.registerServerCommand((ICommand)new CommandGCHelp());
        event.registerServerCommand((ICommand)new CommandGCKit());
        event.registerServerCommand((ICommand)new CommandGCHouston());
        event.registerServerCommand((ICommand)new CommandGCEnergyUnits());
        event.registerServerCommand((ICommand)new CommandJoinSpaceRace());
        event.registerServerCommand((ICommand)new CommandRotatePlayer());
        WorldUtil.initialiseDimensionNames();
        WorldUtil.registerSpaceStations(event.getServer(), new File(worldFolder, "galacticraft"));
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (!body.shouldAutoRegister() || WorldUtil.registerPlanet(body.getDimensionID(), body.getReachable(), 0)) continue;
            body.setUnreachable();
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent var1) {
        MapUtil.saveMapProgress();
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppedEvent var1) {
        WorldUtil.unregisterPlanets();
        WorldUtil.unregisterSpaceStations();
        GCCoreUtil.notifyStarted(null);
    }

    private static void registerCoreGameScreens() {
        if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
            GameScreenBasic rendererBasic = new GameScreenBasic();
            GameScreenCelestial rendererCelest = new GameScreenCelestial();
            GalacticraftRegistry.registerScreen(rendererBasic);
            GalacticraftRegistry.registerScreen(rendererBasic);
            GalacticraftRegistry.registerScreen(rendererCelest);
            GalacticraftRegistry.registerScreen(rendererCelest);
            GalacticraftRegistry.registerScreen(rendererCelest);
        } else {
            GalacticraftRegistry.registerScreensServer(5);
        }
    }

    private void registerTileEntities() {
        GalacticraftCore.registerTileEntity(TileEntityTreasureChest.class, "GC Treasure Chest");
        GalacticraftCore.registerTileEntity(TileEntityOxygenDistributor.class, "GC Air Distributor");
        GalacticraftCore.registerTileEntity(TileEntityOxygenCollector.class, "GC Air Collector");
        GalacticraftCore.registerTileEntity(TileEntityFluidPipe.class, "GC Oxygen Pipe");
        GalacticraftCore.registerTileEntity(TileEntityAirLock.class, "GC Air Lock Frame");
        GalacticraftCore.registerTileEntity(TileEntityRefinery.class, "GC Refinery");
        GalacticraftCore.registerTileEntity(TileEntityNasaWorkbench.class, "GC NASA Workbench");
        GalacticraftCore.registerTileEntity(TileEntityDeconstructor.class, "GC Deconstructor");
        GalacticraftCore.registerTileEntity(TileEntityOxygenCompressor.class, "GC Air Compressor");
        GalacticraftCore.registerTileEntity(TileEntityFuelLoader.class, "GC Fuel Loader");
        GalacticraftCore.registerTileEntity(TileEntityLandingPadSingle.class, "GC Landing Pad");
        GalacticraftCore.registerTileEntity(TileEntityLandingPad.class, "GC Landing Pad Full");
        GalacticraftCore.registerTileEntity(TileEntitySpaceStationBase.class, "GC Space Station");
        GalacticraftCore.registerTileEntity(TileEntityMulti.class, "GC Dummy Block");
        GalacticraftCore.registerTileEntity(TileEntityOxygenSealer.class, "GC Air Sealer");
        GalacticraftCore.registerTileEntity(TileEntityDungeonSpawner.class, "GC Dungeon Boss Spawner");
        GalacticraftCore.registerTileEntity(TileEntityOxygenDetector.class, "GC Oxygen Detector");
        GalacticraftCore.registerTileEntity(TileEntityBuggyFueler.class, "GC Buggy Fueler");
        GalacticraftCore.registerTileEntity(TileEntityBuggyFuelerSingle.class, "GC Buggy Fueler Single");
        GalacticraftCore.registerTileEntity(TileEntityCargoLoader.class, "GC Cargo Loader");
        GalacticraftCore.registerTileEntity(TileEntityCargoUnloader.class, "GC Cargo Unloader");
        GalacticraftCore.registerTileEntity(TileEntityParaChest.class, "GC Parachest Tile");
        GalacticraftCore.registerTileEntity(TileEntitySolar.class, "GC Solar Panel");
        GalacticraftCore.registerTileEntity(TileEntityDish.class, "GC Radio Telescope");
        GalacticraftCore.registerTileEntity(TileEntityCrafting.class, "GC Magnetic Crafting Table");
        GalacticraftCore.registerTileEntity(TileEntityEnergyStorageModule.class, "GC Energy Storage Module");
        GalacticraftCore.registerTileEntity(TileEntityCoalGenerator.class, "GC Coal Generator");
        GalacticraftCore.registerTileEntity(TileEntityElectricFurnace.class, "GC Electric Furnace");
        GalacticraftCore.registerTileEntity(TileEntityAluminumWire.class, "GC Aluminum Wire");
        GalacticraftCore.registerTileEntity(TileEntityAluminumWireSwitch.class, "GC Switchable Aluminum Wire");
        GalacticraftCore.registerTileEntity(TileEntityFallenMeteor.class, "GC Fallen Meteor");
        GalacticraftCore.registerTileEntity(TileEntityIngotCompressor.class, "GC Ingot Compressor");
        GalacticraftCore.registerTileEntity(TileEntityElectricIngotCompressor.class, "GC Electric Ingot Compressor");
        GalacticraftCore.registerTileEntity(TileEntityCircuitFabricator.class, "GC Circuit Fabricator");
        GalacticraftCore.registerTileEntity(TileEntityAirLockController.class, "GC Air Lock Controller");
        GalacticraftCore.registerTileEntity(TileEntityOxygenStorageModule.class, "GC Oxygen Storage Module");
        GalacticraftCore.registerTileEntity(TileEntityOxygenDecompressor.class, "GC Oxygen Decompressor");
        GalacticraftCore.registerTileEntity(TileEntityThruster.class, "GC Space Station Thruster");
        GalacticraftCore.registerTileEntity(TileEntityArclamp.class, "GC Arc Lamp");
        GalacticraftCore.registerTileEntity(TileEntityScreen.class, "GC View Screen");
        GalacticraftCore.registerTileEntity(TileEntityPanelLight.class, "GC Panel Lighting");
        GalacticraftCore.registerTileEntity(TileEntityTelemetry.class, "GC Telemetry Unit");
        GalacticraftCore.registerTileEntity(TileEntityPainter.class, "GC Painter");
        GalacticraftCore.registerTileEntity(TileEntityFluidTank.class, "GC Fluid Tank");
        GalacticraftCore.registerTileEntity(TileEntityPlayerDetector.class, "GC Player Detector");
        GalacticraftCore.registerTileEntity(TileEntityPlatform.class, "GC Platform");
        GalacticraftCore.registerTileEntity(TileEntityEmergencyBox.class, "GC Emergency Post");
        GalacticraftCore.registerTileEntity(TileEntityNull.class, "GC Null Tile");
        if (CompatibilityManager.isIc2Loaded()) {
            GalacticraftCore.registerTileEntity(TileCableIC2Sealed.class, "GC Sealed IC2 Cable");
        }
    }

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String name) {
        GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation("galacticraftcore", name));
    }

    private void registerCreatures() {
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedSpider.class, "evolved_spider", 3419431, 11013646);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedZombie.class, "evolved_zombie", 44975, 7969893);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedCreeper.class, "evolved_creeper", 894731, 0);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedSkeleton.class, "evolved_skeleton", 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(EntitySkeletonBoss.class, "evolved_skeleton_boss", 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(EntityAlienVillager.class, "alien_villager", ColorUtil.to32BitColor(255, 103, 145, 181), 12422002);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedEnderman.class, "evolved_enderman", 0x161616, 0);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedWitch.class, "evolved_witch", 0x340000, 5349438);
    }

    private void registerOtherEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier1Rocket.class, "rocket_t1", 150, 1, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityMeteor.class, "meteor", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityBuggy.class, "buggy", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityFlag.class, "gcflag", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityParachest.class, "para_chest", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityLander.class, "lander", 150, 5, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityMeteorChunk.class, "meteor_chunk", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityCelestialFake.class, "celestial_screen", 150, 5, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityHangingSchematic.class, "hanging_schematic", 150, 5, false);
    }

    static {
        solarSystemSol = GCBodies.solarSystemSol;
        planetMercury = GCBodies.planetMercury;
        planetOverworld = GCBodies.planetOverworld;
        planetJupiter = GCBodies.planetJupiter;
        planetSaturn = GCBodies.planetSaturn;
        planetUranus = GCBodies.planetUranus;
        planetNeptune = GCBodies.planetNeptune;
        moonMoon = GCBodies.moonMoon;
        satelliteSpaceStation = GCBodies.satelliteSpaceStation;
        itemList = new LinkedList();
        itemListTrue = new LinkedList();
        blocksList = new LinkedList();
        biomesList = new LinkedList();
        enableJPEG = true;
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventBusSubscriber(modid="galacticraftcore")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            GCBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
            CompatibilityManager.registerMicroBlocks();
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ForgeRegistry blockRegistry = RegistryManager.ACTIVE.getRegistry(GameData.BLOCKS);
            GCBlocks.doOtherModsTorches((IForgeRegistry<Block>)blockRegistry);
            BlockGrating.createForgeFluidVersions((IForgeRegistry<Block>)blockRegistry);
            GCItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
            if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
                for (Item item : itemListTrue) {
                    GCItems.registerSorted(item);
                }
                for (Block block : blocksList) {
                    GCBlocks.registerSorted(block);
                }
            }
            GCBlocks.oreDictRegistrations();
            GCItems.oreDictRegistrations();
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            RecipeManagerGC.addUniversalRecipes();
            RecipeManagerGC.setConfigurableRecipes();
            if (isPlanetsLoaded) {
                RecipeManagerAsteroids.addUniversalRecipes();
                RecipeManagerMars.addUniversalRecipes();
                RecipeManagerVenus.addUniversalRecipes();
            }
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            proxy.registerVariants();
            if (isPlanetsLoaded) {
                GalacticraftPlanets.proxy.registerVariants();
            }
        }

        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            handler.registerTorchTypes();
            handler.registerItemChanges();
            for (BiomeGenBaseGC biome : biomesList) {
                event.getRegistry().register((IForgeRegistryEntry)biome);
                if (ConfigManagerCore.disableBiomeTypeRegistrations) continue;
                biome.registerTypes(biome);
            }
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
                GCSounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
            }
        }
    }
}

