/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.items.ItemArmorGC;
import micdoodle8.mods.galacticraft.core.items.ItemAxeGC;
import micdoodle8.mods.galacticraft.core.items.ItemBase;
import micdoodle8.mods.galacticraft.core.items.ItemBasic;
import micdoodle8.mods.galacticraft.core.items.ItemBattery;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import micdoodle8.mods.galacticraft.core.items.ItemBuggy;
import micdoodle8.mods.galacticraft.core.items.ItemBuggyMaterial;
import micdoodle8.mods.galacticraft.core.items.ItemCanister;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterOxygenInfinite;
import micdoodle8.mods.galacticraft.core.items.ItemCheese;
import micdoodle8.mods.galacticraft.core.items.ItemEmergencyKit;
import micdoodle8.mods.galacticraft.core.items.ItemFlag;
import micdoodle8.mods.galacticraft.core.items.ItemFood;
import micdoodle8.mods.galacticraft.core.items.ItemFuelCanister;
import micdoodle8.mods.galacticraft.core.items.ItemHoeGC;
import micdoodle8.mods.galacticraft.core.items.ItemIC2Compat;
import micdoodle8.mods.galacticraft.core.items.ItemKey;
import micdoodle8.mods.galacticraft.core.items.ItemMeteorChunk;
import micdoodle8.mods.galacticraft.core.items.ItemMeteoricIron;
import micdoodle8.mods.galacticraft.core.items.ItemMoon;
import micdoodle8.mods.galacticraft.core.items.ItemOilCanister;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenGear;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenMask;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.items.ItemPickaxeGC;
import micdoodle8.mods.galacticraft.core.items.ItemPreLaunchChecklist;
import micdoodle8.mods.galacticraft.core.items.ItemRocketEngineGC;
import micdoodle8.mods.galacticraft.core.items.ItemSchematic;
import micdoodle8.mods.galacticraft.core.items.ItemSensorGlasses;
import micdoodle8.mods.galacticraft.core.items.ItemSpadeGC;
import micdoodle8.mods.galacticraft.core.items.ItemSwordGC;
import micdoodle8.mods.galacticraft.core.items.ItemTier1Rocket;
import micdoodle8.mods.galacticraft.core.items.ItemUniversalWrench;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.StackSorted;
import micdoodle8.mods.galacticraft.core.wrappers.PartialCanister;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GCItems {
    public static Item oxTankLight;
    public static Item oxTankMedium;
    public static Item oxTankHeavy;
    public static Item oxMask;
    public static Item rocketTier1;
    public static Item sensorGlasses;
    public static Item sensorLens;
    public static Item steelPickaxe;
    public static Item steelAxe;
    public static Item steelHoe;
    public static Item steelSpade;
    public static Item steelSword;
    public static Item steelHelmet;
    public static Item steelChestplate;
    public static Item steelLeggings;
    public static Item steelBoots;
    public static Item canister;
    public static Item oxygenVent;
    public static Item oxygenFan;
    public static Item oxygenConcentrator;
    public static Item rocketEngine;
    public static Item heavyPlatingTier1;
    public static Item partNoseCone;
    public static Item partFins;
    public static Item buggy;
    public static Item flag;
    public static Item oxygenGear;
    public static Item parachute;
    public static Item canvas;
    public static Item flagPole;
    public static Item oilCanister;
    public static Item fuelCanister;
    public static Item oxygenCanisterInfinite;
    public static Item schematic;
    public static Item key;
    public static Item partBuggy;
    public static Item basicItem;
    public static Item foodItem;
    public static Item battery;
    public static Item infiniteBatery;
    public static Item meteorChunk;
    public static Item wrench;
    public static Item cheeseCurd;
    public static Item meteoricIronRaw;
    public static Item itemBasicMoon;
    public static Item bucketOil;
    public static Item bucketFuel;
    public static Item prelaunchChecklist;
    public static Item dungeonFinder;
    public static Item ic2compat;
    public static Item emergencyKit;
    public static ItemArmor.ArmorMaterial ARMOR_SENSOR_GLASSES;
    public static ItemArmor.ArmorMaterial ARMOR_STEEL;
    public static Item.ToolMaterial TOOL_STEEL;
    public static ArrayList<Item> hiddenItems;
    public static LinkedList<ItemCanisterGeneric> canisterTypes;
    public static Map<EnumSortCategoryItem, List<StackSorted>> sortMapItems;
    public static HashMap<ItemStack, ItemStack> itemChanges;

    public static void initItems() {
        oxTankLight = new ItemOxygenTank(1, "oxygen_tank_light_full");
        oxTankMedium = new ItemOxygenTank(2, "oxygen_tank_med_full");
        oxTankHeavy = new ItemOxygenTank(3, "oxygen_tank_heavy_full");
        oxMask = new ItemOxygenMask("oxygen_mask");
        rocketTier1 = new ItemTier1Rocket("rocket_t1");
        sensorGlasses = new ItemSensorGlasses("sensor_glasses");
        steelPickaxe = new ItemPickaxeGC("steel_pickaxe");
        steelAxe = new ItemAxeGC("steel_axe");
        steelHoe = new ItemHoeGC("steel_hoe");
        steelSpade = new ItemSpadeGC("steel_shovel");
        steelSword = new ItemSwordGC("steel_sword");
        steelHelmet = new ItemArmorGC(EntityEquipmentSlot.HEAD, "helmet");
        steelChestplate = new ItemArmorGC(EntityEquipmentSlot.CHEST, "chestplate");
        steelLeggings = new ItemArmorGC(EntityEquipmentSlot.LEGS, "leggings");
        steelBoots = new ItemArmorGC(EntityEquipmentSlot.FEET, "boots");
        canister = new ItemCanister("canister");
        oxygenVent = new ItemBase("air_vent");
        oxygenFan = new ItemBase("air_fan");
        oxygenConcentrator = new ItemBase("oxygen_concentrator");
        heavyPlatingTier1 = new ItemBase("heavy_plating").setSmeltingXP(1.0f);
        rocketEngine = new ItemRocketEngineGC("engine");
        partFins = new ItemBase("rocket_fins");
        partNoseCone = new ItemBase("nose_cone");
        sensorLens = new ItemBase("sensor_lens");
        buggy = new ItemBuggy("buggy");
        flag = new ItemFlag("flag");
        oxygenGear = new ItemOxygenGear("oxygen_gear");
        parachute = new ItemParaChute("parachute");
        canvas = new ItemBase("canvas");
        oilCanister = new ItemOilCanister("oil_canister_partial");
        fuelCanister = new ItemFuelCanister("fuel_canister_partial");
        oxygenCanisterInfinite = new ItemCanisterOxygenInfinite("infinite_oxygen");
        flagPole = new ItemBase("steel_pole");
        schematic = new ItemSchematic("schematic");
        key = new ItemKey("key");
        partBuggy = new ItemBuggyMaterial("buggymat");
        basicItem = new ItemBasic("basic_item");
        foodItem = new ItemFood("food");
        battery = new ItemBattery("battery");
        infiniteBatery = new ItemBatteryInfinite("infinite_battery");
        meteorChunk = new ItemMeteorChunk("meteor_chunk");
        wrench = new ItemUniversalWrench("standard_wrench");
        cheeseCurd = new ItemCheese(1, 0.1f, false);
        meteoricIronRaw = new ItemMeteoricIron("meteoric_iron_raw");
        itemBasicMoon = new ItemMoon("item_basic_moon");
        prelaunchChecklist = new ItemPreLaunchChecklist("prelaunch_checklist");
        dungeonFinder = new ItemBase("dungeonfinder");
        ic2compat = new ItemIC2Compat("ic2compat");
        emergencyKit = new ItemEmergencyKit("emergency_kit");
        GCItems.registerHarvestLevels();
        GCItems.registerItems();
        itemChanges.put(new ItemStack(basicItem, 1, 15), new ItemStack(foodItem, 1, 0));
        itemChanges.put(new ItemStack(basicItem, 1, 16), new ItemStack(foodItem, 1, 1));
        itemChanges.put(new ItemStack(basicItem, 1, 17), new ItemStack(foodItem, 1, 2));
        itemChanges.put(new ItemStack(basicItem, 1, 18), new ItemStack(foodItem, 1, 3));
        GalacticraftCore.proxy.registerCanister(new PartialCanister(oilCanister, "galacticraftcore", "oil_canister_partial", 7));
        GalacticraftCore.proxy.registerCanister(new PartialCanister(fuelCanister, "galacticraftcore", "fuel_canister_partial", 7));
    }

    public static void oreDictRegistrations() {
        for (int i = 0; i < ItemBasic.names.length; ++i) {
            if (!ItemBasic.names[i].contains("ingot") && !ItemBasic.names[i].contains("compressed") && !ItemBasic.names[i].contains("wafer")) continue;
            String name = ItemBasic.names[i];
            while (name.contains("_")) {
                int loc = name.indexOf("_");
                name = name.substring(0, loc) + name.substring(loc + 1, loc + 2).toUpperCase() + name.substring(loc + 2, name.length());
            }
            OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(basicItem, 1, i));
        }
        OreDictionary.registerOre((String)"foodCheese", (ItemStack)new ItemStack(cheeseCurd, 1, 0));
        OreDictionary.registerOre((String)"compressedMeteoricIron", (ItemStack)new ItemStack(itemBasicMoon, 1, 1));
        OreDictionary.registerOre((String)"ingotMeteoricIron", (ItemStack)new ItemStack(itemBasicMoon, 1, 0));
        if (CompatibilityManager.useAluDust()) {
            OreDictionary.registerOre((String)"dustAluminum", (ItemStack)new ItemStack(ic2compat, 1, 0));
            OreDictionary.registerOre((String)"dustAluminium", (ItemStack)new ItemStack(ic2compat, 1, 0));
        }
        if (CompatibilityManager.isIc2Loaded()) {
            OreDictionary.registerOre((String)"crushedAluminum", (ItemStack)new ItemStack(ic2compat, 1, 2));
            OreDictionary.registerOre((String)"crushedPurifiedAluminum", (ItemStack)new ItemStack(ic2compat, 1, 1));
            OreDictionary.registerOre((String)"dustTinyTitanium", (ItemStack)new ItemStack(ic2compat, 1, 7));
        }
        GalacticraftCore.proxy.registerCanister(new PartialCanister(oilCanister, "galacticraftcore", "oil_canister_partial", 7));
        GalacticraftCore.proxy.registerCanister(new PartialCanister(fuelCanister, "galacticraftcore", "fuel_canister_partial", 7));
        OreDictionary.registerOre((String)ConfigManagerCore.otherModsSilicon, (ItemStack)new ItemStack(basicItem, 1, 2));
    }

    public static void hideItemsJEI(IIngredientBlacklist jeiHidden) {
        if (jeiHidden != null) {
            for (ItemStack itemStack : itemChanges.keySet()) {
                jeiHidden.addIngredientToBlacklist((Object)itemStack.func_77946_l());
            }
            for (Item item : hiddenItems) {
                jeiHidden.addIngredientToBlacklist((Object)new ItemStack(item, 1, 0));
            }
            for (Block block : GCBlocks.hiddenBlocks) {
                jeiHidden.addIngredientToBlacklist((Object)new ItemStack(block, 1, 0));
                if (block != GCBlocks.slabGCDouble) continue;
                for (int j = 1; j < (GalacticraftCore.isPlanetsLoaded ? 7 : 4); ++j) {
                    jeiHidden.addIngredientToBlacklist((Object)new ItemStack(block, 1, j));
                }
            }
        }
    }

    public static void finalizeSort() {
        ArrayList itemOrderListItems = Lists.newArrayList();
        for (EnumSortCategoryItem type : EnumSortCategoryItem.values()) {
            List<StackSorted> stackSorteds = sortMapItems.get((Object)type);
            if (stackSorteds != null) {
                itemOrderListItems.addAll(stackSorteds);
                continue;
            }
            System.out.println("ERROR: null sort stack: " + type.toString());
        }
        Ordering tabSorterItems = Ordering.explicit((List)itemOrderListItems).onResultOf(input -> new StackSorted(input.func_77973_b(), input.func_77952_i()));
        GalacticraftCore.galacticraftItemsTab.setTabSorter((Comparator<ItemStack>)tabSorterItems);
    }

    public static void registerHarvestLevels() {
        steelPickaxe.setHarvestLevel("pickaxe", 4);
        steelAxe.setHarvestLevel("axe", 4);
        steelSpade.setHarvestLevel("shovel", 4);
    }

    public static void registerSorted(Item item) {
        if (item instanceof ISortableItem) {
            ISortableItem sortableItem = (ISortableItem)item;
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a((CreativeTabs)GalacticraftCore.galacticraftItemsTab, items);
            for (ItemStack stack : items) {
                EnumSortCategoryItem categoryItem = sortableItem.getCategory(stack.func_77952_i());
                if (!sortMapItems.containsKey((Object)categoryItem)) {
                    sortMapItems.put(categoryItem, new ArrayList());
                }
                sortMapItems.get((Object)categoryItem).add(new StackSorted(stack.func_77973_b(), stack.func_77952_i()));
            }
        } else if (item.func_77640_w() == GalacticraftCore.galacticraftItemsTab) {
            throw new RuntimeException(item.getClass() + " must inherit " + ISortableItem.class.getSimpleName() + "!");
        }
    }

    public static void registerItems() {
        GCItems.registerItem("galacticraftcore", rocketTier1);
        GCItems.registerItem("galacticraftcore", oxMask);
        GCItems.registerItem("galacticraftcore", oxygenGear);
        GCItems.registerItem("galacticraftcore", oxTankLight);
        GCItems.registerItem("galacticraftcore", oxTankMedium);
        GCItems.registerItem("galacticraftcore", oxTankHeavy);
        GCItems.registerItem("galacticraftcore", oxygenCanisterInfinite);
        GCItems.registerItem("galacticraftcore", sensorLens);
        GCItems.registerItem("galacticraftcore", sensorGlasses);
        GCItems.registerItem("galacticraftcore", wrench);
        GCItems.registerItem("galacticraftcore", steelPickaxe);
        GCItems.registerItem("galacticraftcore", steelAxe);
        GCItems.registerItem("galacticraftcore", steelHoe);
        GCItems.registerItem("galacticraftcore", steelSpade);
        GCItems.registerItem("galacticraftcore", steelSword);
        GCItems.registerItem("galacticraftcore", steelHelmet);
        GCItems.registerItem("galacticraftcore", steelChestplate);
        GCItems.registerItem("galacticraftcore", steelLeggings);
        GCItems.registerItem("galacticraftcore", steelBoots);
        GCItems.registerItem("galacticraftcore", canister);
        GCItems.registerItem("galacticraftcore", oxygenVent);
        GCItems.registerItem("galacticraftcore", oxygenFan);
        GCItems.registerItem("galacticraftcore", oxygenConcentrator);
        GCItems.registerItem("galacticraftcore", rocketEngine);
        GCItems.registerItem("galacticraftcore", heavyPlatingTier1);
        GCItems.registerItem("galacticraftcore", partNoseCone);
        GCItems.registerItem("galacticraftcore", partFins);
        GCItems.registerItem("galacticraftcore", flagPole);
        GCItems.registerItem("galacticraftcore", canvas);
        GCItems.registerItem("galacticraftcore", oilCanister);
        GCItems.registerItem("galacticraftcore", fuelCanister);
        GCItems.registerItem("galacticraftcore", schematic);
        GCItems.registerItem("galacticraftcore", key);
        GCItems.registerItem("galacticraftcore", partBuggy);
        GCItems.registerItem("galacticraftcore", buggy);
        GCItems.registerItem("galacticraftcore", basicItem);
        GCItems.registerItem("galacticraftcore", foodItem);
        GCItems.registerItem("galacticraftcore", battery);
        GCItems.registerItem("galacticraftcore", infiniteBatery);
        GCItems.registerItem("galacticraftcore", meteorChunk);
        GCItems.registerItem("galacticraftcore", cheeseCurd);
        GCItems.registerItem("galacticraftcore", meteoricIronRaw);
        GCItems.registerItem("galacticraftcore", itemBasicMoon);
        GCItems.registerItem("galacticraftcore", flag);
        GCItems.registerItem("galacticraftcore", parachute);
        GCItems.registerItem("galacticraftcore", prelaunchChecklist);
        GCItems.registerItem("galacticraftcore", dungeonFinder);
        GCItems.registerItem("galacticraftcore", emergencyKit);
        canisterTypes.add((ItemCanisterGeneric)fuelCanister);
        canisterTypes.add((ItemCanisterGeneric)oilCanister);
        if (CompatibilityManager.useAluDust()) {
            GCItems.registerItem(ic2compat);
        }
    }

    public static void registerItem(String modid, Item item) {
        String name = item.func_77658_a().substring(5);
        item.setRegistryName(new ResourceLocation(modid, name));
        GCItems.registerItem(item);
    }

    public static void registerItem(Item item) {
        String name = item.func_77658_a().substring(5);
        if (item.getRegistryName() == null) {
            item.setRegistryName(name);
        }
        GCCoreUtil.registerGalacticraftItem(name, item);
        GalacticraftCore.itemListTrue.add(item);
        GalacticraftCore.proxy.postRegisterItem(item);
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        for (ItemStack item : GalacticraftCore.itemList) {
            registry.register((IForgeRegistryEntry)item.func_77973_b());
        }
    }

    static {
        ARMOR_SENSOR_GLASSES = EnumHelper.addArmorMaterial((String)"SENSORGLASSES", (String)"", (int)200, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
        ARMOR_STEEL = EnumHelper.addArmorMaterial((String)"steel", (String)"", (int)30, (int[])new int[]{3, 6, 8, 3}, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
        TOOL_STEEL = EnumHelper.addToolMaterial((String)"steel", (int)3, (int)768, (float)5.0f, (float)2.0f, (int)8);
        hiddenItems = new ArrayList();
        canisterTypes = new LinkedList();
        sortMapItems = Maps.newHashMap();
        itemChanges = new HashMap(4, 1.0f);
    }
}

